/**
 * Project Name:activity-center-api<br>
 * File Name:RemoteGuidePageService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.remoteservice<br>
 * Date:2017年3月3日下午2:16:27<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.activity.center.api.remoteservice;

import java.util.Date;
import java.util.List;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.GuidePageDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.GuidePageDto;
import cn.com.duiba.tuia.activity.center.api.dto.GuidePageSkinDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteGuidePageService <br/>
 * 引导页相关dubbo接口 date: 2017年3月3日 下午2:16:27 <br/>.
 *
 * @author youhaijun
 * @version
 * @since JDK 1.6
 */
public interface RemoteGuidePageService {

    /**
     * Save guide page skin.
     *
     * @param req the req
     * @return the dubbo result< boolean>
     */
    DubboResult<Long> saveGuidePageSkin(GuidePageSkinDto req);

    /**
     * Delete guide page skin.
     *
     * @param id the id
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> deleteGuidePageSkin(Long id);

    /**
     * Gets the guide page skin list.
     *
     * @param offset the offset
     * @param max the max
     * @return the guide page skin list
     */
    DubboResult<PageDto<GuidePageSkinDto>> getGuidePageSkinList(Integer offset, Integer max);
    
    /**
     * getGuidePageSkinList:(根据类型查询皮肤). <br/>
     * @param suitableType
     * @return
     */
    DubboResult<List<GuidePageSkinDto>> getGuidePageSkinList(Integer suitableType);

    /**
     * Gets the guide page skin detail.
     *
     * @param id the id
     * @return the guide page skin detail
     */
    DubboResult<GuidePageSkinDto> getGuidePageSkinDetail(Long id);

    /**
     * Save guide page.
     *
     * @param req the req
     * @return the dubbo result< boolean>
     */
    DubboResult<Long> saveGuidePage(GuidePageDto req);

    /**
     * Delete guide page.
     *
     * @param id the id
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> deleteGuidePage(Long id);

    /**
     * Gets the guide page detail.
     *
     * @param id the id
     * @return the guide page detail
     */
    DubboResult<GuidePageDto> getGuidePageDetail(Long id);

    /**
     * 获取引导页统计数据.
     *
     * @param id 根据引导页ID搜索
     * @param title 根据引导页名称模糊搜索
     * @param offset 分页偏移量
     * @param max 分页最大限制
     * @param start 开始日期，没有开始日期则查全部
     * @param end 结束日期，没有结束日期则查询到当天
     * @return the guide page data
     */
    DubboResult<PageDto<GuidePageDataDto>> getGuidePageData(Long id, String title, Integer offset, Integer max,Date start, Date end);
    
    /**
     * isRelateGuidePage:(活动是否关联引导页). <br/>
     * @param activityId
     * @return
     */
    DubboResult<Boolean> isRelateGuidePage(Long activityId);

}
