/**
 * Project Name:activity-center-api<br>
 * File Name:ProbType.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.constant<br>
 * Date:2017年3月30日下午2:00:30<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.constant;

/**
 * ClassName: ProbType <br/>
 * Function: 概率类型. <br/>
 * Reason: . <br/>
 * date: 2017年3月30日 下午2:00:30 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public enum ProbType {
    BROB(1, "浮标", "tuia_buoy_rate"),
    BACK(2, "返回", "tuia_return_rate");

    /** The code. */
    private Integer code;

    /** The desc. */
    private String  desc;

    /** config key. */
    private String  key;

    private ProbType(Integer code, String desc, String key) {
        this.code = code;
        this.desc = desc;
        this.key = key;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getKey() {
        return key;
    }

    /**
     * getProbType:(根据code值获取对应的枚举). <br/>
     * 
     * @param code
     * @return ProbType
     */
    public ProbType getProbType(int code) {
        for (ProbType temp : ProbType.values()) {
            if (temp.getCode() == code) {
                return temp;
            }
        }
        return null;
    }

}
