/**
 * Project Name:activity-center-api<br>
 * File Name:RemoteBuoyService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.remoteservice<br>
 * Date:2017年3月29日下午4:00:46<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */
package cn.com.duiba.tuia.activity.center.api.remoteservice;

import java.util.Date;
import java.util.List;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.constant.EntranceType;
import cn.com.duiba.tuia.activity.center.api.dto.BuoyDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.BuoyDto;
import cn.com.duiba.tuia.activity.center.api.dto.ProbDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName: RemoteBuoyService <br/>
 * Function: 浮标接口. <br/>
 * Reason: . <br/>
 * date: 2017年3月29日 下午4:00:46 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
public interface RemoteBuoyService {
    /**
     * saveBuoy:(保存). <br/>
     * @param dto
     * @return
     */
    DubboResult<Long> saveBuoy(BuoyDto dto);
    
    /**
     * selectList:(查询). <br/>
     * @param start
     * @param end
     * @param offset
     * @param max
     * @return
     */
    DubboResult<PageDto<BuoyDataDto>> selectList(Date start,Date end,Integer offset,Integer max);
    
    /**
     * selectAll:(查询所有). <br/>
     * @return
     */
    DubboResult<List<BuoyDto>> selectAll();
    
    
    /**
     * deleteBuoy:(删除). <br/>
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteBuoy(Long id);
    
    /**
     * selectById:(根据id查询). <br/>
     * @param id
     * @return
     */
    DubboResult<BuoyDto> selectById(Long id);
    
    /**
     * selectProb:(查概率). <br/>
     * @return
     */
    DubboResult<ProbDto> selectProb(EntranceType type);
    
    /**
     * saveProb:(保存). <br/>
     * @param type
     * @return
     */
    DubboResult<Boolean> saveProb(EntranceType type,ProbDto dto);
}
