/**
 * Project Name:Demo<br>
 * File Name:TinyPngKey.java<br>
 * Package Name:org.gradle.model<br>
 * Date:2017年4月19日下午3:38:29<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.activity.center.api.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;

import com.tinify.Tinify;

/**
 * ClassName: TinyPngKey <br/>
 * date: 2017年4月19日 下午3:38:29 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
@Resource
public class TinyPngUtil {

    /** The key list. */
    private static List<String> keyList;

    /**
     * Sets the key map.
     */
    @PostConstruct
    private static void setKeyMap() {
        keyList.add("C_1L1oH4NMSbcTzh_OxoHikotCskB-V-");
        keyList.add("6BiRDdptlzn2-cjtE29e1e-A5EbYpgJk");
        keyList.add("eQM0SEE1Lz7Qlp8b5VlviWfczvf0ANk_");
    }

    /**
     * Gets the api key.
     *
     * @return the api key
     */
    private String getApiKey() {
        setKeyMap();
        for (String key : keyList) {
            Tinify.setKey(key);
            if (Tinify.validate() && Tinify.compressionCount() <= 500) {
                return key;
            }
        }
        return StringUtils.EMPTY;
    }

    /**
     * 调用TinyPNG接口压缩图片.
     *
     * @param bytes 字节码格式图片信息
     * @return 压缩之后的InputStream
     * @throws ActivityCenterException the activity center exception
     */
    public InputStream compressionBytes(byte[] bytes) throws Exception {
        String key = getApiKey();
        if (StringUtils.isEmpty(key)) {
            throw new Exception("没有可用的ApiKey,请添加新的TinyPNG的apiKey");
        }
        Tinify.setKey(key);
        try {
            return new ByteArrayInputStream(Tinify.fromBuffer(bytes).toBuffer());
        } catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

}
