/**
 * Project Name:activity-center-api<br>
 * File Name:RemoteLandService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.remoteservice<br>
 * Date:2017年3月24日上午10:29:26<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */
package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandInterfaceLogDto;
import cn.com.duiba.tuia.activity.center.api.dto.LandUserInfoDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * ClassName: RemoteLandService <br/>
 * Function: 落地页接口. <br/>
 * Reason: 落地页相关服务. <br/>
 * date: 2017年3月24日 上午10:29:26 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
public interface RemoteLandService {
    
    /**
     * selectLandById:(查询落地页信息). <br/>
     * 客户端务必做缓存
     * @param id
     * @return
     */
    DubboResult<LandDto> selectLandById(Long id);
    
    /**
     * saveLand:(保存落地页). <br/>
     * @param dto
     * @return
     */
    DubboResult<Long> saveLand(LandDto dto);
    
    /**
     * deleteLand:(删除落地页). <br/>
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteLand(Long id);
    
    /**
     * selectLandList:(查询落地页). <br/>
     * @param id
     * @param title
     * @param offset
     * @param max
     * @return
     */
    DubboResult<PageDto<LandDto>> selectLandList(Long id,String title,Integer offset,Integer max);
    
    /**
     * insertUserInfo:(添加用户信息). <br/>
     * @param dto
     * @return
     */
    DubboResult<Long> insertUserInfo(LandUserInfoDto dto);
    
    /**
     * selectUserPhoneExist:(查询手机号是否存在). <br/>
     * @param userPhone
     * @param landId
     * @return
     */
    DubboResult<Boolean> selectUserPhoneExist(String userPhone,Long landId);
    
    /**
     * selectIdentificationExist:(查询身份证号是否存在). <br/>
     * @param identification
     * @param landId
     * @return
     */
    DubboResult<Boolean> selectIdentificationExist(String identification,Long landId);
    
    /**
     * 
     * insertLandInterfaceLog:(落地页日志插入). <br/>
     * @return
     */
    DubboResult<Boolean> insertLandInterfaceLog(LandInterfaceLogDto dto);
}
