/**
 * Project Name:activity-center-api<br>
 * File Name:Prob.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年3月29日下午8:54:03<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import cn.com.duiba.tuia.activity.center.api.common.Probability;
import cn.com.duiba.tuia.activity.center.api.constant.PageType;

/**
 * ClassName: ProbDto <br/>
 * Function: 浮标跳转概率Dto. <br/>
 * Reason: . <br/>
 * date: 2017年3月29日 下午8:54:03 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class ProbDto extends BaseDto {

    private static final long serialVersionUID = 1L;
    /** actCenter:活动中心 概率. */
    private Probability       actCenter;
    /** mainMeet:主会场 概率. */
    private Probability       mainMeet;
    /** activity:活动 概率. */
    private Probability       activity;

    public Probability getActCenter() {
        return actCenter;
    }

    public void setActCenter(Probability actCenter) {
        this.actCenter = actCenter;
    }

    public Probability getMainMeet() {
        return mainMeet;
    }

    public void setMainMeet(Probability mainMeet) {
        this.mainMeet = mainMeet;
    }

    public Probability getActivity() {
        return activity;
    }

    public void setActivity(Probability activity) {
        this.activity = activity;
    }

    /**
     * isSuitable:(概率和是否等于指定值，默认为100%). <br/>
     * @param persent
     * @return
     */
    public boolean isSuitable(Integer persent) {
        int suitable = persent == null ? 100 : persent;
        if (actCenter != null && mainMeet != null && activity != null) {
            int percent = actCenter.intPercentValue() + mainMeet.intPercentValue() + activity.intPercentValue();
            if (percent == suitable) {
                return true;
            }
        }
        return false;
    }

    /**
     * selectMaxProbability:(查询概率最大的). <br/>
     * @return
     */
    public Integer selectMaxProbability() {
        int acp = 0;
        int ap = 0;
        int mp = 0;
        if (actCenter != null) {
            acp = actCenter.intPercentValue();
        }
        if (activity != null) {
            ap = activity.intPercentValue();
        }
        if (mainMeet != null) {
            mp = mainMeet.intPercentValue();
        }

        PageType rs = PageType.ACTIVITY;
        if (acp > ap) {
            rs = PageType.ACTCENTER;
            if (mp > acp) {
                rs = PageType.MAINMEET;
            }

        } else if (mp > ap) {
            rs = PageType.MAINMEET;
        }
        return rs.getCode();
    }
}
