package cn.com.duiba.tuia.activity.center.api.constant;

/**
 * Created by wubo on 2017/7/10.
 * 支付宝订单 状态枚举
 */
public enum AlipayOrderStatus {

    NULL(0,"无状态","无状态","无状态","无状态"),
    DEALING(1, "处理中", "账户未填写",null, null),
    SUCCESS(2, "转账成功", "已完成",null, null),
    CONSUMER_ERROR(3, "用户账户异常", "账户错误", "异常,账户信息错误", "异常,账户信息错误"),
    SYSTEM_ERROR(4, "非用户异常", "处理中", "异常,推啊支付宝账户错误", "异常"),
    OVERDUE(5, "逾期未领取", "已关闭,逾期未领取", null, null),
    FORCE_CLOSE(6, "强制关闭", "已完成", null, null),
    TRANSFER(7, "转账中", "处理中", null, null);

    /**
     * 正常订单 集合
     */
    private static Integer[] normalStatus = {DEALING.getStatus(), SUCCESS.getStatus(), OVERDUE.getStatus(),
            FORCE_CLOSE.getStatus(), TRANSFER.getStatus()};

    /**
     * 异常订单 集合
     */
    private static Integer[] errorStatus = {CONSUMER_ERROR.getStatus(), SYSTEM_ERROR.getStatus()};
    private Integer status;
    private String statusType;
    private String userTip;
    private String adminTip;
    private String mediaTip;

    AlipayOrderStatus(Integer status, String statusType, String userTip, String adminTip, String mediaTip) {
        this.status = status;
        this.userTip = userTip;
        this.adminTip = null == adminTip? userTip:adminTip;
        this.statusType = statusType;
        this.mediaTip = null == mediaTip? userTip:mediaTip;
    }

    public static Integer[] normalStatus() {
        return normalStatus;
    }

    public static Integer[] errorStatus() {
        return errorStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public String getUserTip() {
        return userTip;
    }

    public String getAdminTip() {
        return adminTip;
    }

    public String getStatusType() {
        return statusType;
    }

    public String getMediaTip() {
        return mediaTip;
    }

    public static AlipayOrderStatus getEnumByStatus(Integer status) {
        for (AlipayOrderStatus s : AlipayOrderStatus.values()) {
            if (s.status.equals(status)) {
                return s;
            }
        }
        return NULL;
    }
}
