/**
 * Project Name:activity-center-api<br>
 * File Name:LandUserInfoDto.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年3月23日下午7:48:36<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import java.util.Date;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;

/**
 * ClassName: LandUserInfoDto <br/>
 * Function: 落地页用户信息Dto. <br/>
 * Reason: 落地页用户提交的相关信息. <br/>
 * date: 2017年3月23日 下午7:48:36 <br/>
 *
 * @author wubo
 * @since JDK 1.7
 */
public class LandUserInfoDto extends BaseDto {

    private static final long serialVersionUID = 1L;
    private Long              id;

    /** landId:落地页表id. */
    private Long              landId;

    /** channel:落地页渠道. */
    private String            channel;

    /** consumerId:用户id. */
    private Long              consumerId;

    /** appId:来源appId. */
    private Long              appId;

    /** appName:来源appName. */
    private String            appName;

    /** advertId:广告id. */
    private Long              advertId;

    /** activityId:活动id. */
    private Long              activityId;

    /** advertPlanId:广告计划id. */
    private Long              advertPlanId;

    /** advertMediaId:广告媒体id. */
    private Long              advertMediaId;

    /** userName:姓名. */
    private String            userName;

    /** userPhone:电话. */
    private String            userPhone;

    /** identification:身份证号. */
    private String            identification;

    /** sex:性别：女:0，男：1. */
    private Integer           sex;

    /** address:地址. */
    private String            address;

    /** birthday:生日. */
    private Date              birthday;

    /** region:区域/县. */
    private String            region;

    /** city:城市. */
    private String            city;

    /** province:省份. */
    private String            province;

    /** info:其他信息（json）. */
    private String            info;

    /** 手机归属省份 */
    private String            phoneProvince;

    /** 手机归属城市 */
    private String            phoneCity;

    /** age:年龄. */
    private Integer           age;

    /** professio:职业. */
    private String            profession;

    /** education:学历. */
    private String            education;

    /** fee:费用. */
    private String            fee;

    /** email:邮件. */
    private String            email;

    /** color:颜色. */
    private String            colour;

    /** number:数量. */
    private Integer           number;

    /** orderMessage:订单留言. */
    private String            orderMessage;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getLandId() {
        return landId;
    }

    public void setLandId(Long landId) {
        this.landId = landId;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getAdvertPlanId() {
        return advertPlanId;
    }

    public void setAdvertPlanId(Long advertPlanId) {
        this.advertPlanId = advertPlanId;
    }

    public Long getAdvertMediaId() {
        return advertMediaId;
    }

    public void setAdvertMediaId(Long advertMediaId) {
        this.advertMediaId = advertMediaId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    public String getIdentification() {
        return identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getPhoneProvince() {
        return phoneProvince;
    }

    public void setPhoneProvince(String phoneProvince) {
        this.phoneProvince = phoneProvince;
    }

    public String getPhoneCity() {
        return phoneCity;
    }

    public void setPhoneCity(String phoneCity) {
        this.phoneCity = phoneCity;
    }

    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public String getProfession() {
        return profession;
    }

    public void setProfession(String profession) {
        this.profession = profession;
    }

    public String getEducation() {
        return education;
    }

    public void setEducation(String education) {
        this.education = education;
    }

    public String getFee() {
        return fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getColour() {
        return colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getOrderMessage() {
        return orderMessage;
    }

    public void setOrderMessage(String orderMessage) {
        this.orderMessage = orderMessage;
    }
}
