package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.RspOrder;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteActivityOrderService <br/>
 * Function: 活动订单相关服务. <br/>
 * date: 2017年2月24日 下午3:02:09 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
public interface RemoteActivityOrderService {

    /**
     * insert:(添加活动订单). <br/>
     *
     * @author wubo
     * @param dto
     * @return orderId
     * @since JDK 1.7
     */
    public DubboResult<RspOrder> insert(ActivityOrderDto dto);

    /**
     * update:(更新). <br/>
     * orderId必填 其他字段只更新填写的字段
     * 
     * @author wubo
     * @param dto
     * @return
     * @since JDK 1.7
     */
    public DubboResult<Long> updateByOrderId(ActivityOrderDto dto);

    /**
     * selectByConsumerId:(根据用户id查询). <br/>
     *
     * @author wubo
     * @param consumerId 用户id
     * @param offset
     * @param max
     * @return PageDto<ActivityOrderDto>
     * @since JDK 1.7
     */
    public DubboResult<PageDto<ActivityOrderDto>> selectByConsumerId(Long consumerId, Integer offset, Integer max);

    /**
     * selectByIdAndConsumerId:(根据订单id和用户id查询). <br/>
     *
     * @author wubo
     * @param consumerId
     * @param orderId
     * @return
     * @since JDK 1.7
     */
    public DubboResult<ActivityOrderDto> selectByOrderIdAndConsumerId(String orderId, Long consumerId);

    /**
     * selectConsumerJoinNumToday:(查询用户今天活动参数次数). <br/>
     *
     * @author wubo
     * @param consumerId
     * @param activityId
     * @return
     * @since JDK 1.7
     */
    public DubboResult<Integer> selectConsumerJoinNumToday(Long consumerId, Long activityId);

    /**
     * incrConsumerJoinNumToday:(用户今天参与活动次数+1). <br/>
     *
     * @author wubo
     * @param consumerId
     * @param activityId
     * @return
     * @since JDK 1.7
     */
    public DubboResult<Boolean> incrConsumerJoinNumToday(Long consumerId, Long activityId);

    /**
     * decrConsumerJoinNumToday:(用户今天参与活动次数-1). <br/>
     *
     * @author wubo
     * @param consumerId
     * @param activityId
     * @return
     * @since JDK 1.7
     */
    public DubboResult<Boolean> decrConsumerJoinNumToday(Long consumerId, Long activityId);
}
