package cn.com.duiba.tuia.activity.center.api.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by Administrator on 2017/7/20.
 */
public class MathUtil {


/**
     * @Description: yuan2Fen
     *
     * @Param: [yuan]
     * @Return: java.lang.String
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/21
     */
    public static String yuan2Fen(String yuan) throws Exception {
        NumberFormat format = NumberFormat.getInstance();
        Number number = format.parse(yuan);
        double temp = number.doubleValue() * 100.0;
        // 默认情况下GroupingUsed属性为true 不设置为false时,输出结果为2,012
        format.setGroupingUsed(false);
        // 设置返回数的小数部分所允许的最大位数
        format.setMaximumFractionDigits(0);

        return format.format(temp);
    }

    /**
     * @Description: yuan2Fen
     *
     * @Param: [yuan]
     * @Return: java.lang.String
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/21
     */
    public static String yuan2Fen(int yuan) {
        NumberFormat format = NumberFormat.getInstance();
        double temp = (double) yuan * 100.0;
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(0);

        return format.format(temp);
    }

    /**
     * @Description: yuan2Fen 保留2位小数,注意传入的String是否位数字
     *
     * @Param: [yuan]
     * @Return: java.lang.String
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/21
     */
    public static String fen2Yuan(String fen) {
        final int MULTIPLIER = 100;
        return new BigDecimal(fen).divide(new BigDecimal(MULTIPLIER)).setScale(2).toString();
    }

    /**
     * @Description: yuan2Fen 保留2位小数
     *
     * @Param: [yuan]
     * @Return: java.lang.String
     * @throws:
     * @author: youhaijun
     * @Date:   2017/7/21
     */
    public static String fen2Yuan(int fen) {
        final int MULTIPLIER = 100;
        return new BigDecimal(fen).divide(new BigDecimal(MULTIPLIER)).setScale(2).toString();
    }

}
