/**
 * Project Name:activity-center-api<br>
 * File Name:PrizeDto.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年6月1日上午10:46:51<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ClassName: PrizeDto <br/>
 * Function: 奖项Dto. <br/>
 * Reason: . <br/>
 * date: 2017年6月1日 上午10:46:51 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.8
 */
public class PrizeDto extends BaseDto {

    private static final long serialVersionUID = 1L;
    
    /** 奖品类型：实物 */
    public static final String PHYSICAL_PRIZE_TYPE = "physical";

    /** 奖品类型：虚拟商品 */
    public static final String VIRTUAL_PRIZE_TYPE  = "virtual";

    private Long              id;

    /** title:奖品标题. */
    private String            title;

    /** prizeType:奖项类型. */
    private String            prizeType;

    /** listImage:列表图片. */
    private String            listImage;

    /** bannerImage:banner图. */
    private String            bannerImage;

    /** detailImage:详情图. */
    private String            detailImage;

    /** description:.说明 */
    private String            description;

    /** detailDesc:详细说明. */
    private String            detailDesc;

    /** stockId:库存id. */
    private Long              stockId;

    /** stock:库存值（管理端查询时用）. */
    private Integer           stock;

    /** totalStock:总库存(管理端查询时用) */
    private Integer           totalStock;

    /** stockChange:库存变化值（管理端保存时用）. */
    private Integer           stockChange;

    /** visionPlanner:视觉. */
    private String            visionPlanner;

    /** isOpen:是否开启. */
    private Boolean           isOpen;

    /** isDeleted:是否删除. */
    private Boolean           isDeleted;

    /** 以json string格式保存的扩展信息*/
    private String extInfo;

    /** 奖品价值，以json格式保存在extInfo中*/
    private Integer prizeValue;
    
    /**api充值*/
    private ApiRechargeDto apiRechargeDto;

    /**账号收集*/
    private List<AccountRechargeDto> accountRechargeDto;
   

    /**劵码*/
    private CouponsCodeDto couponsCodeDto;
    
    /** accountSwitch:账号开关(0:关 1：开). */
    private Integer accountSwitch;

    public Integer getPrizeValue() {
        return prizeValue;
    }

    public void setPrizeValue(Integer prizeValue) {
        this.prizeValue = prizeValue;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public String getListImage() {
        return listImage;
    }

    public void setListImage(String listImage) {
        this.listImage = listImage;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getDetailImage() {
        return detailImage;
    }

    public void setDetailImage(String detailImage) {
        this.detailImage = detailImage;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetailDesc() {
        return detailDesc;
    }

    public void setDetailDesc(String detailDesc) {
        this.detailDesc = detailDesc;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    public Integer getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Integer totalStock) {
        this.totalStock = totalStock;
    }

    public Integer getStockChange() {
        return stockChange;
    }

    public void setStockChange(Integer stockChange) {
        this.stockChange = stockChange;
    }

    public String getVisionPlanner() {
        return visionPlanner;
    }

    public void setVisionPlanner(String visionPlanner) {
        this.visionPlanner = visionPlanner;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Boolean getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setValueByExtInfo() {
        if(StringUtils.isNotBlank(this.getExtInfo())) {
            this.setPrizeValue(JSONObject.parseObject(this.getExtInfo()).getIntValue("prizeValue"));
        }
    }

    public void setExtInfoByValue(){
        Map<String,Object> map = new HashMap<>(1);
        map.put("prizeValue",this.getPrizeValue());
        this.setExtInfo(JSON.toJSONString(map));
    }
    
    public ApiRechargeDto getApiRechargeDto() {
        return apiRechargeDto;
    }

    
    public void setApiRechargeDto(ApiRechargeDto apiRechargeDto) {
        this.apiRechargeDto = apiRechargeDto;
    }

    
    
    public CouponsCodeDto getCouponsCodeDto() {
        return couponsCodeDto;
    }

    
    public void setCouponsCodeDto(CouponsCodeDto couponsCodeDto) {
        this.couponsCodeDto = couponsCodeDto;
    }
    
    public Integer getAccountSwitch() {
        return accountSwitch;
    }
    
    public void setAccountSwitch(Integer accountSwitch) {
        this.accountSwitch = accountSwitch;
    }
    
    public List<AccountRechargeDto> getAccountRechargeDto() {
        return accountRechargeDto;
    }
    
    public void setAccountRechargeDto(List<AccountRechargeDto> accountRechargeDto) {
        this.accountRechargeDto = accountRechargeDto;
    }

}
