/**
 * Project Name:activity-center-api
 * File Name:VirtualGoodsInfoDto.java
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto
 * Date:2017年11月13日下午5:15:48
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.activity.center.api.dto;

import java.util.HashMap;
import java.util.List;

import com.alibaba.fastjson.JSON;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;

/**
 * ClassName:VirtualGoodsInfoDto <br/>
 * Function: 虚拟商品. <br/>
 * Date:     2017年11月13日 下午5:15:48 <br/>
 * @author   guyan
 * @version  
 * @see 	 
 */
public class VirtualGoodsInfoDto extends BaseDto{

    /**序列号*/
    private static final long serialVersionUID = -3081469676034835097L;
    
    /**api充值*/
    public static final Integer API_VIRTUAL_TYPE=0;
    /**劵码充值*/
    public static final Integer COUPONS_CODE_VIRTUAL_TYPE=1;
    /**账号充值*/
    public static final Integer ACCOUNT_VIRTUAL_TYPE=2;
    
    /**虚拟商品类型, API充值 0 券码充值 1 账号充值 2*/
    private  Integer virtualType;
    
    /**虚拟商品子类型*/
    private Integer  subType;
    
    /**奖品库id*/
    private Long     prizeId;
    
    /**扩展信息字段*/
    private String   extInfo;
    
    
    public Integer getVirtualType() {
        return virtualType;
    }

    
    public void setVirtualType(Integer virtualType) {
        this.virtualType = virtualType;
    }

    
    public Integer getSubType() {
        return subType;
    }

    
    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    
    public Long getPrizeId() {
        return prizeId;
    }

    
    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    
    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }
    
    public void setExtInfoByValue(PrizeDto dto){ 
        Integer accountSwitch=dto.getAccountSwitch();
        List<AccountRechargeDto> list=dto.getAccountRechargeDto();
        HashMap<String,Object> map = null;
        if (getVirtualType()==API_VIRTUAL_TYPE) {
           map=new HashMap<>(5);
           ApiRechargeDto apiDto=dto.getApiRechargeDto();
           map.put("rechargeInfo", apiDto==null ? "":apiDto.getRechargeInfo());
           map.put("prizeIdent", apiDto==null ? "":apiDto.getPrizeIdent());
           map.put("valueUnit", apiDto==null ? "":apiDto.getValueUnit());
           map.put("accountSwitch", accountSwitch==null? "":accountSwitch);
           map.put("accountInfo",list.isEmpty()? "":list);
        }else if (getVirtualType()==COUPONS_CODE_VIRTUAL_TYPE) {
            map=new HashMap<>(6);
            CouponsCodeDto couponsDto=dto.getCouponsCodeDto();
            map.put("validStartDate", couponsDto==null ? "":couponsDto.getValidStartDate());
            map.put("validEndDate", couponsDto==null ? "":couponsDto.getValidEndDate());
            map.put("couponsCode", couponsDto==null ? "":couponsDto.getCouponsCode());
            map.put("couponsPwd", couponsDto==null ? "":couponsDto.getCouponsPwd());
            map.put("useInfo ", couponsDto==null ? "":couponsDto.getUseInfo());
            map.put("skipLink", couponsDto==null ? "":couponsDto.getSkipLink());
        }else if (getVirtualType()==ACCOUNT_VIRTUAL_TYPE) {
            map=new HashMap<>(5);
            CouponsCodeDto couponsDto=dto.getCouponsCodeDto();
            map.put("validStartDate", couponsDto==null ? "":couponsDto.getValidStartDate());
            map.put("validEndDate", couponsDto==null ? "":couponsDto.getValidEndDate());
            map.put("linkInfo", couponsDto==null ? "":couponsDto.getLinkInfo());
            map.put("accountSwitch", accountSwitch==null? "":accountSwitch);
            map.put("accountInfo",list.isEmpty()? "":list);
        }
        this.setExtInfo(JSON.toJSONString(map));
    }
    
    public void setValueByExtInfo(){
        
    }
}

