package cn.com.duiba.tuia.activity.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.LayerSkinDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.Map;

/**
 * Created by wubo on 2017/8/16.
 * 皮肤相关服务
 */
public interface RemoteSkinService {

    /**
     * 分页查询弹层皮肤
     * @param type 类型 选填
     * @param id id 选填
     * @param name 名称 选填
     * @param offset offset 默认 0
     * @param max max 默认20
     * @return PageDto
     */
    DubboResult<PageDto<LayerSkinDto>> selectLayerSkinPage(Integer type, Long id, String name, Integer offset, Integer max);

    /**
     * 查询弹层皮肤
     * @param id
     * @return
     */
    DubboResult<LayerSkinDto> selectLayerSkin(Long id);

    /**
     * 保存弹层皮肤
     */
    DubboResult<Long> saveLayerSkin(LayerSkinDto dto);

    /**
     * 查询所有类型弹层皮肤
     *
     * 支付宝随机（1个），支付宝定额（1个），谢谢参与（1个），广告弹层（需指定弹层id）
     * @param couponSkinId 广告弹层id
     * @return list
     */
    DubboResult<List<LayerSkinDto>> selectAllLayerSkin(Long couponSkinId);

    /**
     * 查询所有非广告弹层
     * 支付宝随机（1个），支付宝定额（1个），谢谢参与（1个)
     * @return list
     */
    DubboResult<List<LayerSkinDto>> selectConstantLayerSkin();

    /***
         * @Description: selectAllSkinTypes 获取目前所有的活动皮肤名称
         * 保存形式：<skin_type, shin_name>
         * @Param: [dto]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Map>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/9/25
         */
    DubboResult<Map<String, String>> selectAllSkinTypes();
}
