package cn.com.duiba.tuia.activity.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.activity.center.api.dto.CouponsCodeDto;
import cn.com.duiba.tuia.activity.center.api.dto.PrizeDto;
import cn.com.duiba.tuia.activity.center.api.dto.RspTakeCoupon;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqVirtualRecharge;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 虚拟奖品服务
 */
public interface RemoteVirtualService {
	/**
	 * 虚拟商品API 充值
	 * @param req
	 * @return
	 */
	DubboResult<Boolean> recharge(ReqVirtualRecharge req);
	
	/**
	 * 虚拟商品获取优惠券
	 * @param virtualId 虚拟商品 奖品Id
	 * @return
	 */
	DubboResult<RspTakeCoupon> takeCoupon(String virtualId);
	
	/**
	 * 
	 * getCouponsList:(获取劵码list). <br/>
	 *
	 * @author guyan
	 * @param prizeId
	 * @param status
	 * @return
	 */
	DubboResult<List<CouponsCodeDto>> getCouponsList(Long prizeId,Integer status);
	
	/**
	 * 
	 * deleteCoupons:(删除劵码). <br/>
	 *
	 * @author guyan
	 * @param prizeId
	 * @param status
	 * @return
	 */
	DubboResult<Boolean> deleteCoupons(Long prizeId,Integer status);
	
	/**
	 * updateStock:(修改库存). <br/>
	 *
	 * @author guyan
	 * @param prizeId
	 * @param totalNum
	 * @return
	 */
	DubboResult<Boolean> updateStock(PrizeDto dto);
	
	/**
	 * saveCoupons:(保存劵码). <br/>
	 *
	 * @author guyan
	 * @param list
	 * @return
	 */
	DubboResult<Boolean> saveCoupons(List<CouponsCodeDto> list,Long prizeId);
	
}
