package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.Arrays;
import java.util.List;

/**
 * <li>
 *
 *
 * </li>
 *
 * Created by wubo on 2017/7/10.
 * Updated by GuYan
 */
public enum AlipayType {
    QUOTA(1,"支付宝定额"),
    RANDOM(2,"支付宝随机"),
    PHYSICAL(3, "实物"),

    //api类型:内容充值，任意数充值
    VIRTUAL_API(10, "API"),
    VIRTUAL_API_0(11,"内容充值"),
    VIRTUAL_API_1(12,"任意数充值"),

    //券码类型:普通券码,重复券码,链接
    VIRTUAL_TICKET(13, "劵码"),
    VIRTUAL_TICKET_0(14,"普通劵码"),
    VIRTUAL_TICKET_1(15,"重复劵码"),
    VIRTUAL_TICKET_2(16,"链接"),

    // 账号收集
    VIRTUAL_ACCOUNT(17,"账号收集"),

    QB_QUOTA(21,"QB定额"),
    QB_RANDOM(22,"QB随机"),
    ;

    private Integer type;

    private String  desc;

    public static final List<Integer> ALI_TYPE      = Arrays.asList(QUOTA.getType(), RANDOM.getType());
    public static final List<Integer> QB_TYPE      = Arrays.asList(QB_QUOTA.getType(), QB_RANDOM.getType());

    public static final List<Integer> PHYSICAL_TYPE = Arrays.asList(PHYSICAL.getType());

    public static final List<Integer> VIRTUAL_TYPE  = Arrays.asList(VIRTUAL_API.getType(), VIRTUAL_TICKET.getType(),
                                                                    VIRTUAL_ACCOUNT.getType());
    //虚拟商品-api
    public static final List<Integer> VIRTUAL_API_TYPE  = Arrays.asList(VIRTUAL_API_0.getType(), VIRTUAL_API_1.getType());

    //虚拟商品-劵码
    public static final List<Integer> VIRTUAL_TICKET_TYPE  = Arrays.asList(VIRTUAL_TICKET_0.getType(), VIRTUAL_TICKET_1.getType(), VIRTUAL_TICKET_2.getType());

    // 全部虚拟商品
    public static final List<Integer> VIRTUAL_All_TYPE        = Arrays.asList(VIRTUAL_API.getType(),
                                                                          VIRTUAL_TICKET.getType(),
                                                                          VIRTUAL_ACCOUNT.getType(),
                                                                          VIRTUAL_API_0.getType(),
                                                                          VIRTUAL_API_1.getType(),
                                                                          VIRTUAL_TICKET_0.getType(),
                                                                          VIRTUAL_TICKET_1.getType(),
                                                                          VIRTUAL_TICKET_2.getType());

    AlipayType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean isAli(Integer type){
        return ALI_TYPE.contains(type);
    }
    public static boolean isQB(Integer type){
        return QB_TYPE.contains(type);
    }

    public static boolean isPhysical(Integer type){
        return PHYSICAL_TYPE.contains(type);
    }

    public static boolean isVirtual(Integer type){
        return VIRTUAL_TYPE.contains(type);
    }

    //检查是否是虚拟奖品
    public static boolean isVirturalOrSubVirtural(Integer type){
        return VIRTUAL_All_TYPE.contains(type);
    }

    //校验是否是api充值
    public static boolean isVirtualApi(Integer type){
        return VIRTUAL_API_TYPE.contains(type);
    }

    //校验是否是劵码充值
    public static boolean isVirtualTicket(Integer type){
        return VIRTUAL_TICKET_TYPE.contains(type);
    }

    public static String getDesc(Integer type) {
        if (type == null) {
            return "";
        }
        switch (type) {
            case 1:
                return QUOTA.getDesc();
            case 2:
                return RANDOM.getDesc();
            case 3:
                return PHYSICAL.getDesc();
            case 10:
                return VIRTUAL_API.getDesc();
            case 11:
                return VIRTUAL_API_0.getDesc();
            case 12:
                return VIRTUAL_API_1.getDesc();
            case 13:
                return VIRTUAL_TICKET.getDesc();
            case 14:
                return VIRTUAL_TICKET_0.getDesc();
            case 15:
                return VIRTUAL_TICKET_1.getDesc();
            case 16:
                return VIRTUAL_TICKET_2.getDesc();
            case 17:
                return VIRTUAL_ACCOUNT.getDesc();
            default:
                break;
        }
        return "";
    }

    public static List<Integer> getAllAliType(){
        return ALI_TYPE;
    }

    public static List<Integer> getAllPhysicalType(){
        return PHYSICAL_TYPE;
    }

    public static List<Integer> getAllVirtual(){
        return VIRTUAL_All_TYPE;
    }


}
