package cn.com.duiba.tuia.activity.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.BalanceRecordDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceRecordMove;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceRecordQueryDto;

@AdvancedFeignClient
public interface RemoteBalanceRecordService {

    /**
     * 获取用户的金额变动记录
     * 
     * @param queryDto 查询对象
     * @return 余额记录列表
     */
    List<BalanceRecordDto> list(BalanceRecordQueryDto queryDto);

    /**
     * 统计符合条件的记录数
     * 
     * @param queryDto 查询对象
     * @return 记录数
     */
    Integer count(BalanceRecordQueryDto queryDto);

    /**
     * 财务记录迁移
     * 
     * @param moveRequest 迁移请求
     * @return 迁移结果
     */
    Boolean move(BalanceRecordMove moveRequest);

    PageDto<BalanceRecordDto> pageList(BalanceRecordQueryDto queryDto);
}
