/**
 * Project Name:activity-center-common<br>
 * File Name:EntityUtil.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.common.util<br>
 * Date:2017年3月8日下午3:46:22<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */
package cn.com.duiba.tuia.activity.center.api.util;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * ClassName: EntityUtil <br/>
 * Function: 类工具. <br/>
 * date: 2017年3月8日 下午3:46:22 <br/>
 *
 * @author wubo
 * @since JDK 1.7
 */
public class EntityUtil {

    private EntityUtil(){}

    /**
         * @Description: transf 将list转化为map,key为lamda表达式定义
         *
         * @Param: [list, t]
         * @Return: java.util.Map<K,E>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/6/22
         */
    public static <K, E> Map<K,E> transf(List<E> list,Function<E,K> t){

        Map<K,E> map = new HashMap<>();
        for(E e:list){
            map.put(t.apply(e), e);
        }
        return map;
    }

    /**
         * @Description: getParam 从List<Dto>中提取某个参数的list
         *
         * @Param: [list, t]
         * @Return: java.util.List<K>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/6/22
         */
    public static <K, E> List<K> getParam(List<E> list, Function<E,K> t){

        List<K> result = new ArrayList<>();
        for(E e : list){
            K k = t.apply(e);
            if (k != null) {
                result.add(k);
            }
        }
        return result;
    }
    
}
