/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import cn.com.duiba.tuia.activity.center.api.common.Probability;
import cn.com.duiba.tuia.activity.center.api.constant.PageType;
import cn.com.duiba.tuia.activity.center.api.dto.RateDto;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;

public class ProbDto
extends BaseDto {
    private static final long serialVersionUID = 1L;
    private Probability actCenter;
    private Probability mainMeet;
    private Probability activity;
    private Probability directPage;
    private Probability url;
    private List<RateDto> urlList;
    private List<RateDto> mainMeetList;
    private List<Long> buoyIdList;
    private List<RateDto> directPageList;

    public static RateDto calRate(List<RateDto> list, Integer totalRate) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Integer total = totalRate;
        if (total == null) {
            total = ProbDto.sumRate(list);
        }
        if (total == null || total == 0) {
            return null;
        }
        int point = RandomUtils.nextInt((int)0, (int)total);
        for (RateDto dto : list) {
            Integer rate = dto.getRate();
            if (rate == null || rate == 0) continue;
            if (rate >= point) {
                return dto;
            }
            point -= rate.intValue();
        }
        return null;
    }

    public static Integer sumRate(List<RateDto> list) {
        int total = 0;
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (RateDto dto : list) {
            Integer rate = dto.getRate();
            if (rate == null) continue;
            total += rate.intValue();
        }
        return total;
    }

    public List<Long> getBuoyIdList() {
        return this.buoyIdList;
    }

    public void setBuoyIdList(List<Long> buoyIdList) {
        this.buoyIdList = buoyIdList;
    }

    public Probability getUrl() {
        return this.url;
    }

    public void setUrl(Probability url) {
        this.url = url;
    }

    public List<RateDto> getUrlList() {
        return this.urlList;
    }

    public void setUrlList(List<RateDto> urlList) {
        this.urlList = urlList;
    }

    public List<RateDto> getMainMeetList() {
        return this.mainMeetList;
    }

    public void setMainMeetList(List<RateDto> mainMeetList) {
        this.mainMeetList = mainMeetList;
    }

    public Probability getActCenter() {
        return this.actCenter;
    }

    public void setActCenter(Probability actCenter) {
        this.actCenter = actCenter;
    }

    public Probability getMainMeet() {
        return this.mainMeet;
    }

    public void setMainMeet(Probability mainMeet) {
        this.mainMeet = mainMeet;
    }

    public Probability getActivity() {
        return this.activity;
    }

    public void setActivity(Probability activity) {
        this.activity = activity;
    }

    public Probability getDirectPage() {
        return this.directPage;
    }

    public void setDirectPage(Probability directPage) {
        this.directPage = directPage;
    }

    public List<RateDto> getDirectPageList() {
        return this.directPageList;
    }

    public void setDirectPageList(List<RateDto> directPageList) {
        this.directPageList = directPageList;
    }

    public boolean isSuitable(Integer persent) {
        int suitable;
        int n = suitable = persent == null ? 100 : persent;
        if (this.actCenter != null && this.mainMeet != null && this.directPage != null) {
            int percent = this.actCenter.intPercentValue() + this.mainMeet.intPercentValue() + this.directPage.intPercentValue();
            if (null != this.url) {
                percent += this.url.intPercentValue();
            }
            if (percent == suitable) {
                return true;
            }
        }
        return false;
    }

    public boolean isSuitableMainMeetList() {
        if (0 != this.mainMeet.intPercentValue()) {
            if (null == this.mainMeetList || this.mainMeetList.isEmpty()) {
                return false;
            }
            int percent = 0;
            for (RateDto dto : this.mainMeetList) {
                percent += dto.getRate().intValue();
            }
            if (100 == percent) {
                return true;
            }
        }
        return false;
    }

    public Integer selectMaxProbability() {
        int acp = 0;
        int ap = 0;
        int mp = 0;
        if (this.actCenter != null) {
            acp = this.actCenter.intPercentValue();
        }
        if (this.activity != null) {
            ap = this.activity.intPercentValue();
        }
        if (this.mainMeet != null) {
            mp = this.mainMeet.intPercentValue();
        }
        PageType rs = PageType.ACTIVITY;
        if (acp > ap) {
            rs = PageType.ACTCENTER;
            if (mp > acp) {
                rs = PageType.MAINMEET;
            }
        } else if (mp > ap) {
            rs = PageType.MAINMEET;
        }
        return rs.getCode();
    }
}

