package cn.com.duiba.tuia.activity.center.api.constant;

import cn.com.duiba.tuia.activity.center.api.dto.FishingConfigDto;
import cn.com.duiba.tuia.activity.center.api.dto.PuzzleDto;

/***
 * @Description: 推啊游戏类型
 *
 * @Param:
 * @Return:
 * @throws:
 * @author: youhaijun
 * @Date: 2018/1/23
 */
public enum GameType {
    FISHING(1, "捕鱼类", FishingConfigDto.class),
    PUZZLE(2, "拼图类", PuzzleDto.class),
    BET(2, "押注类", null),
    ZERO(0, "无", null);

    private Integer type;
    private String desc;
    private Class clazz;

    GameType(Integer type, String desc, Class clazz) {
        this.type = type;
        this.desc = desc;
        this.clazz = clazz;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Class getClazz() {
        return clazz;
    }

    public static GameType getGameType(Integer type) {
        for (GameType game : GameType.values()) {
            if (game.getType().equals(type)) {
                return game;
            }
        }
        return GameType.ZERO;
    }

}
