package cn.com.duiba.tuia.activity.center.api.cache;

import java.util.concurrent.TimeUnit;

/**
 * ClassName: CacheSpace <br/>
 * Function: 缓存枚举. <br/>
 * Reason: 配置方便. <br/>
 * Attention:注释必须注明缓存的业务，参数维度，缓存的类，不注明者死全家!
 * 缓存key=TAC-key-参数...
 * date: 2017年1月19日 下午8:49:44 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public enum CacheSpace {
//    /** 活动缓存 维度:id */
//    ACTIVITY("01", 30, TimeUnit.SECONDS),

    /** 活动皮肤缓存 维度:活动id */
    ACTIVITY_SKIN("02", 1, TimeUnit.HOURS),

    // 皮肤模板参数变更，变更缓存key 以便兼容上线，看着不顺眼下次可改回
    /** 皮肤模板 维度:skinType */
    SKINTEMPLATE_TYPE("03", 10, TimeUnit.MINUTES),

    /** 皮肤模板 维度:id */
    SKINTEMPLATE_ID("04", 10, TimeUnit.MINUTES),

    /** 活动每日参与次数 维度：用户维度id，活动id,日期 */
    ACTIVITY_JOIN("05", 1, TimeUnit.DAYS),
    
    /** 引导页详情,包含关联的活动 维度:引导页id*/
    GUIDEPAGE("060",1,TimeUnit.MINUTES),
    
    /** GUIDEPAGESKIN:引导页皮肤,维度:引导页id.*/
    GUIDEPAGE_SKIN("07",10,TimeUnit.MINUTES),
    
    /** 活动详情缓存 维度:id */
    ACTIVITY_DETAIL("08", 30, TimeUnit.SECONDS),
    
    /** 落地页详情 维度:id */
    LAND_DETAIL("09",10,TimeUnit.MINUTES),
    
    /** 最新引导页详情缓存 维度:pageType.*/
    GUIDEPAGE_RECENT("10",5,TimeUnit.MINUTES),

    /** 浮标 维度:id */
    BUOY("11", 5, TimeUnit.MINUTES),

    /** 浮标列表 维度:无 */
    BUOY_ALL("12", 5, TimeUnit.MINUTES),
    
    /** 入口类型概率缓存 维度：概率类型(浮标/返回).*/
    ENTRANCE_PROB("013",5,TimeUnit.MINUTES),
    
    /** 插件皮肤缓存.*/
    PLUGIN_SKIN("14",30,TimeUnit.MINUTES),
    
    /** 插件奖项缓存.*/
    PLUGIN_OPTION("15",10,TimeUnit.MINUTES),
    
    /** 插件皮肤缓存.*/
    PLUGIN("16",10,TimeUnit.MINUTES),
    
    /** 奖品缓存,维度:奖项id,缓存类:PrizeDto (不包含库存值，库存值要实时去库存中心查询)*/
    PRIZE("17",010,TimeUnit.MINUTES),

    /** 奖项缓存,维度:活动id+奖项id,缓存类:ActivityOptionEntity (不包含库存值，库存值要实时去库存中心查询)*/
    OPTIONS("018",3,TimeUnit.MINUTES),

    /** 奖项缓存,维度:奖项id,缓存类:Map<optionId,ActivityOptionEntity> (不包含库存值，库存值要实时去库存中心查询)*/
    OPTION("0019",3,TimeUnit.MINUTES),

    ALIPAY_ORDER("20",150,TimeUnit.MINUTES),

    /** 默认直投页，0维度，缓存默认直投页的id */
//    DEFAULT_DIRECT_PAGE("21",10,TimeUnit.MINUTES)

    /** 配置项缓存 */
    SYSTEM_CONFIG("22",5,TimeUnit.MINUTES),

    /** 直投页区块缓存 */
    GUIDE_PAGE_BLOCK("23",5,TimeUnit.MINUTES),

    /** 响应式插件列表缓存 */
    RESPONSIVE_PLUGIN_BLOCK("024",1,TimeUnit.MINUTES),

    /**定时插件列表（永久）*/
    TIMING_PLUGIN_BLOCK("25",-1,TimeUnit.MINUTES),
	
	/** 虚拟商品普通券码 key **/
	VIRTUAL_COUPON("26",-1,TimeUnit.DAYS),

	/** 虚拟商品分布式锁 key **/
	VIRTUAL_LOCK_KEY("27", 30, TimeUnit.SECONDS),

    /** 虚拟商品普通批次券码 key **/
	VIRTUAL_BATCH("28",-1,TimeUnit.DAYS),

	/** 虚拟商品分布式锁 key **/
	VIRTUAL_LOCK_BATCH("29", 30, TimeUnit.SECONDS),

    /** 客服信息模版缓存 **/
    CONTACT_PLATE("30", 5, TimeUnit.MINUTES),

    /** 支付宝领取记录缓存 **/
    ALI_ACCOUNT("31", 1, TimeUnit.DAYS),

    /** 支付宝领取记录缓存 **/
    REAL_BALANCE("32", 1, TimeUnit.DAYS),

    /**
     * 重复领取支付宝告警列表
     */
    ALI_WARN_SET("33", 1, TimeUnit.DAYS),
    /**
     * 同一个账号同一个活动的重复领奖记录
     */
    ALI_DUPLICATE_ORDER_SET("34", 1, TimeUnit.DAYS),

    /** 捕鱼游戏金币变更 永不过期*/
    FISH_AMOUNT_CHANGE("35", 1000, TimeUnit.DAYS),

    /** 捕鱼游戏金币变更 对应的配置信息 永不过期*/
    FISH_AMOUNT_CHANGE_CONFIG_INFO("36", 1000, TimeUnit.DAYS),

    /** 捕鱼游戏金币变更初始值 永不过期*/
    FISH_AMOUNT_START("37", 1000, TimeUnit.DAYS),

    /** 押注游戏时间值 */
    BET_GAME_TIME("38",1000,TimeUnit.DAYS),

    /** 上期游戏数据 */
    BET_GAME_LAST_RESULT("39",1000,TimeUnit.DAYS),

    /** 本期游戏数据 */
    BET_GAME_RESULT("40",1000,TimeUnit.DAYS),

    /** 押注游戏总赚取 */
    BET_GAME_TOTAL_EARN("41",1000,TimeUnit.DAYS),

    /** 押注游戏总消耗 */
    BET_GAME_TOTAL_CONSUME("42",1000,TimeUnit.DAYS),

    /** 押注游戏用户消耗 */
    BET_GAME_USER_CONSUME("43",1000,TimeUnit.DAYS),
    /** 用户中奖 */
    BET_GAME_USER_EARN("44",1000,TimeUnit.DAYS),

    /** key每次+1，缓存时间根据实际情况制定.*/
    SIMPLE("n++",1,TimeUnit.DAYS);



    private static final String SPACE = "TAC";

    /**
     * 缓存key标识 缓存key=TAC-key标识-参数 注意:key不允许重复
     */
    private String              key;

    /**
     * 缓存时间
     */
    private int                 time;

    /**
     * 时间单位
     */
    private TimeUnit            unit;

    CacheSpace(String key, int time, TimeUnit unit) {
        this.key = key;
        this.time = time;
        this.unit = unit;
    }

    public String getKey() {
        return key;
    }

    public int getTime() {
        return time;
    }

    public TimeUnit getUnit() {
        return unit;
    }

    public String generatorKey(Object... params) {
        StringBuilder sb = new StringBuilder(SPACE + "-");
        sb.append(key);
        if (params != null) {
            for (Object temp : params) {
                sb.append("-");
                sb.append(temp);
            }
        }

        return sb.toString();
    }
}
