/**
 * Project Name:activity-center-api
 * File Name:CouponsCodeDto.java
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto
 * Date:2017年11月13日下午4:55:37
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;

/**
 * ClassName:CouponsCodeDto <br/>
 * Function: 劵码. <br/>
 * Date:     2017年11月13日 下午4:55:37 <br/>
 * 该类字段 以json格式存在奖品订单表中，已上线在用的字段不允许更改属性名，否则有兼容问题
 * @author   guyan
 * @version  
 * @see 	 
 */
public class CouponsCodeDto extends BaseDto {
    
    /**序列号*/
    private static final long serialVersionUID = 5062532387181940174L;

    public static final String LINK_INFO = "linkInfo";
    public static final String USE_INFO ="useInfo";
    public static final String COUPONS_CODE = "couponsCode";
    public static final String COUPONS_WORD = "couponsPwd";
    public static final String VALID_START_DATE = "validStartDate";
    public static final String VALID_END_DATE = "validEndDate";

    /** couponsValidity:劵码开始有效期. */
    private String validStartDate;
   
    /** couponsValidity:劵码结束有效期. */
    private String validEndDate;
   
    /** couponsCode:劵码编号. */
    private String couponsCode;
    
    /** couponsPwd:劵码密码. */
    private String couponsPwd;
    
    /** useInfo:使用说明. */
    private String useInfo;
    
    /** linkInfo:链接. */
    private String linkInfo;
    
    /**删除状态*/
    private Integer deleteStatus;
    
    /**奖品id*/
    private Long   pid;


    /** 批次Id */
    private Long batchId;
    
   
    public Long getPid() {
        return pid;
    }

    
    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getCouponsCode() {
        return couponsCode;
    }
    
    public void setCouponsCode(String couponsCode) {
        this.couponsCode = couponsCode;
    }
    
    public String getCouponsPwd() {
        return couponsPwd;
    }
    
    public void setCouponsPwd(String couponsPwd) {
        this.couponsPwd = couponsPwd;
    }
    
    public String getUseInfo() {
        return useInfo;
    }
    
    public void setUseInfo(String useInfo) {
        this.useInfo = useInfo;
    }
    
    public String getLinkInfo() {
        return linkInfo;
    }
    
    public void setLinkInfo(String linkInfo) {
        this.linkInfo = linkInfo;
    }
    
    public String getValidStartDate() {
        return validStartDate;
    }

    
    public void setValidStartDate(String validStartDate) {
        this.validStartDate = validStartDate;
    }

    
    public String getValidEndDate() {
        return validEndDate;
    }

    
    public void setValidEndDate(String validEndDate) {
        this.validEndDate = validEndDate;
    }
    
    public Integer getDeleteStatus() {
        return deleteStatus;
    }

    
    public void setDeleteStatus(Integer deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    public Long getBatchId() {
        return batchId;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }
}

