package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.constant.GameType;
import cn.com.duiba.tuia.activity.center.api.dto.GameAdvertDto;
import cn.com.duiba.tuia.activity.center.api.dto.GameConfigDto;
import cn.com.duiba.tuia.activity.center.api.dto.NickNameDto;

import java.util.List;

/**
 * 推啊游戏服务
 *
 * Created by Administrator on 2018/1/23.
 */
@AdvancedFeignClient
public interface RemoteGameService {

    /***
         * @Description: saveGameConfig
         * 带id则为update 否则为insert
         * @Param: [gameConfigDto]
         * @Return: java.lang.Integer
         * @throws:
         * @author: youhaijun
         * @Date:   2018/1/23
         */
    Long saveGameConfig(GameConfigDto gameConfigDto);

    Integer deleteGameConfig(Long id);

    GameConfigDto selectGame(Long id);

    PageDto<GameConfigDto> selectGameList(Integer offset, Integer max, Long id, String title, GameType type);

    List<GameAdvertDto> getAdvertByGame(Long gameId);

    Integer saveBatchAdvert(List<GameAdvertDto> gameAdvertDtos);

    Integer deleteAdvertByGameId(Long gameId);

    /**
     * 获取下一个可用昵称
     * @param id 当用户已分配过昵称时，获取下一个昵称需要回传之前分配过的id，便于释放
     * @return
     */
    NickNameDto getNext(Long id);

    /**
     * 确认使用该昵称
     * @param dto
     * @return
     */
    Boolean confirmNickName(NickNameDto dto);
}
