package cn.com.duiba.tuia.activity.center.api.dto.consumer;

import cn.com.duiba.tuia.activity.center.api.constant.SlotLoginType;

import java.io.Serializable;

/**
 * 给推啊游戏用户体系专用缓存类
 * 此类会在用户通过各种途径登录时候缓存到redis集群中，key为"TPW-USER-userId"
 * Created by youhaijun on 2017/12/11.
 */
public class ConsumerCache implements Serializable {

    public static final String REDIS_KEY = "TPW-USER-";

    /**
     * 用户ID，发号器产生
     */
    private Long userId;
    /**
     * 性别
     *
     * @see cn.com.duiba.tuia.activity.center.api.constant.SexType
     */
    private Integer sex;

    /**
     * 昵称
     */
    private String nickName;
    /**
     * 头像
     */
    private String img;
    /**
     * 登录类型
     *
     * @see SlotLoginType
     */
    private Integer loginType;

    public ConsumerCache() {
    }

    public ConsumerCache(Long userId) {
        this.userId = userId;
    }
    public ConsumerCache(Long userId, Integer sex, String nickName, String img, Integer loginType) {
        this.userId = userId;
        this.sex = sex;
        this.nickName = nickName;
        this.img = img;
        this.loginType = loginType;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public Integer getLoginType() {
        return loginType;
    }

    public void setLoginType(Integer loginType) {
        this.loginType = loginType;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

}
