package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.constant.BalanceType;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityWinOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.UserBalanceDto;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceRecordAdd;
import cn.com.duiba.tuia.activity.center.api.dto.consumer.req.BalanceWithdrawReq;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterException;

import java.util.Date;

@AdvancedFeignClient
public interface RemoteUserBalanceService {

    /**
     * 创建用户金额帐号
     * 
     * @param userId 用户id
     * @param type 账户类型
     * @return 金额账户id
     */
    Long createBalanceAccount(Long userId, BalanceType type);

    /**
     * 支持创建带有初始值的账户
     * @param userId
     * @param type
     * @param initAmount
     * @return
     */
    Long createBalanceAccountWithInit(Long userId, BalanceType type, Long initAmount);

    /**
     * 根据用户id获取金额账户列表
     * 
     * @param userId 用户id
     * @return 用户金额列表
     */
    UserBalanceDto getByType(Long userId, BalanceType type);

    /**
     * 更新货币账户余额.这个方法还会记录货币账户的明细
     *
     * @return 更新结果 true-成功 false-失败
     */
    Boolean updateAmount(BalanceRecordAdd adder);

    String updateAmount4OrderId(BalanceRecordAdd adder);

    /**
     * 更新货币账户余额到redis
     *
     * @return 更新结果 true-成功 false-失败
     */
    Boolean updateAmountToRedis(BalanceRecordAdd adder);

    Boolean updateRmbAmount(BalanceRecordAdd adder);
    Boolean flushAmount(Long userId);

    /**
     * 获取余额
     *
     * @param userId 用户id
     * @param type 账户类型
     * @return 余额
     */
    Long getAmount(Long userId, BalanceType type);

    /**
     * 强制更新账户余额为当前值，目前只在第三方媒体作为金币来源时使用（慎用）
     * @param update
     * @return
     */
    Integer forceUpdateAmount(BalanceRecordAdd update);

    /**
     * 获取余额从redis，如果redis不存在则从数据库里查询
     *
     * @param userId 用户id
     * @param type 账户类型 目前账户类型只支持Game，其他返回null
     * @return 余额
     */
    Long getAmountFromRedis(Long userId, BalanceType type);

    Long getRmbAmount(Long userId, BalanceType type);

    /**
     * 现金钱包提现
     *
     * @param req
     * @return
     */
    ActivityWinOrderDto cashWithdraw(BalanceWithdrawReq req) throws ActivityCenterException;

    /**
     * 现金钱包提现 - 管理端重试
     *
     * @param date
     * @param orderId
     * @param aliName
     * @param aliAccount
     * @return
     */
    ActivityWinOrderDto retryCashWithdraw(Date date, String orderId, String aliName, String aliAccount) throws ActivityCenterException;

    /**
     * 更新实时账户余额，内部带有redis隔离，大量调用更新时使用，此更新与getRealAmount（）配合使用
     * @param adder
     * @return false表示更新失败，当支出时需要特别考虑此种返回值
     */
    Boolean updateRealAmount(BalanceRecordAdd adder);

    /**
     * 获取实时账户余额，会根据redis'里的值来计算最新余额，使用此方法时更新请使用updateRealAmount
     * @param userId
     * @param type
     * @return
     */
    Long getRealAmount(Long userId, BalanceType type);
}
