package cn.com.duiba.tuia.activity.center.api.constant;

public enum GameFrom {
    WAN_ZHU(1, "玩主"),
    DEFAULT(0, "自研");
    /**
     * 来源状态
     */
    private Integer origin;
    /**
     * 对应描述
     */
    private String desc;

    GameFrom(Integer origin, String desc) {
        this.origin = origin;
        this.desc = desc;
    }

    public Integer getOrigin() {
        return origin;
    }

    public void setOrigin(Integer origin) {
        this.origin = origin;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     *
     * @param origin　对应数据库中的gameFrom字段
     * @return
     */
    public static GameFrom getGameFrom(Integer origin) {
        for (GameFrom gameFrom : GameFrom.values()) {
            if (gameFrom.getOrigin().equals(origin)) {
                return gameFrom;
            }
        }
        return DEFAULT;
    }
}
