package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.FundChangeDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.FundChangeQueryReq;

@AdvancedFeignClient
public interface RemoteFundChangeService {
    /**
     * 插入流水变更
     *
     * @param dto
     * @return
     */
    int insert(FundChangeDto dto);

    /**
     * 查询流水
     *
     * @param req
     * @return
     */
    PageDto<FundChangeDto> selectByReqQuery(FundChangeQueryReq req);

    /**
     *
     * @param fundBodyId 游戏或者游戏大厅ID
     * @param fundBodyType 0 游戏大厅 1 游戏
     * @return 当前流通货币(单位是金币)
     */
    Long getFlowAmount(Long fundBodyId,Integer fundBodyType);

}
