package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.DuibaSharesDayDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDuibaSharesDayService {
    /**
     * 查询
     *
     * @param id
     * @return
     */
    public DubboResult<DuibaSharesDayDto> select(Long id) ;

    /**
     * 插入
     *
     * @param duibaSharesDayDO
     * @return
     */
    DubboResult<Integer> insert(DuibaSharesDayDto duibaSharesDayDO);

    /**
     * 更新
     *
     * @param duibaSharesDayDO
     * @return
     */
    DubboResult<Integer> update(DuibaSharesDayDto duibaSharesDayDO);


    /**
     * 查询提取股票显示数据
     * @param sharesCode:股票编号
     * @param dataType：数据类型 1是分钟数据结构 ，2是小时数据结构 ，3 是天 数据结构
     * @param updateTime：数据以 时分秒的 数据格式 时间搓 等方式返回， 所以用的Double 方式，用于提取计算
     * @param status：0 是可用 1是不可用
     * @return
     */
    DubboResult<List<DuibaSharesDayDto>> findByCodeAndDataTypeAndTime(String sharesCode, Integer dataType
            , Double updateTime, int status);

    /**
     *  查询提取股票显示数据 只取 等于 updateTime
     * @param sharesCode:股票编号 （必填）
     * @param dataType：数据类型 1是分钟数据结构 ，2是小时数据结构 ，3 是天 数据结构 （必填）
     * @param updateTime：数据以 时分秒的 数据格式 时间搓 等方式返回， 所以用的Double 方式，用于提取计算 （必填）
     * @param status：0 是可用 1是不可用 （必填）
     * @return
     */
    DubboResult<DuibaSharesDayDto> findByCodeAndDataTypeAndTimeOne( String sharesCode,Integer dataType
            , Double updateTime,int status);

    /**
     * 批量插入数据
     * @param dsDtos
     * @return
     */
    DubboResult<Boolean> insertBatch(List<DuibaSharesDayDto> dsDtos);


    /**
     * 获取最新数据
     * @param sharesCode
     * @param dataType
     * @param limit
     * @param status
     * @return
     */
    DubboResult<List<DuibaSharesDayDto>> findByCodeAndDataTypeAndNewList(String sharesCode, Integer dataType, int limit, int status);
}
