/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.constant.ErrorCode;
import cn.com.duiba.tuia.activity.center.api.exception.ActivityCenterRuntimeException;

public enum ActivityTypeNum {
    ACTIVITY(0, 2000),
    PLUGIN(2000, 3000),
    GAME(6000, 7000),
    YOUTUIACTIVITY(8000, 9000);

    private int min;
    private int max;

    private ActivityTypeNum(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMyRealType(int myType) {
        int result = this.getMin() + myType;
        if (result > this.getMax()) {
            throw new ActivityCenterRuntimeException(ErrorCode.E0103010.getErrorCode(), ErrorCode.E0103010.getDesc() + "," + this.name() + "," + myType);
        }
        return result;
    }

    public boolean isType(int activityType) {
        return activityType >= this.getMin() && activityType < this.getMax();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

