package cn.com.duiba.tuia.activity.center.api.constant;

public enum GameVersion {
    /**
     * 默认捕鱼版本，初始版本
     */
    FishV1("1.0","V1.0 2月1日"),
    /**
     * 升级排行榜和结果页，增加特殊怪物 http://cf.dui88.com/pages/viewpage.action?pageId=8528497
     */
    FishV2("2.0","V2.0 5月1日"),
    /**
     * 未知版本
     */
    NULL("0.0","未知版本");
    private String version;
    private String versionDec;

    GameVersion(String version, String versionDec) {
        this.version = version;
        this.versionDec = versionDec;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersionDec() {
        return versionDec;
    }

    public void setVersionDec(String versionDec) {
        this.versionDec = versionDec;
    }
    public static GameVersion getGameVersion(String version) {
        for (GameVersion gameVersion : GameVersion.values()) {
            if (gameVersion.getVersion().equals(version)) {
                return gameVersion;
            }
        }
        return NULL;
    }
}
