package cn.com.duiba.tuia.activity.center.api.remoteservice.youtui;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.youtui.YoutuiActivityDto;
import cn.com.duiba.tuia.activity.center.api.dto.youtui.YoutuiOptionDto;
import cn.com.duiba.tuia.activity.center.api.dto.youtui.YoutuiSkinDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.youtui.YoutuiSkinTemplateDto;

import java.util.List;

/**
 * Created by xuefeng on 2018/5/17.
 */
@AdvancedFeignClient
public interface RemoteYoutuiActivityService {

    /**
     * 获取活动分享列表
     * @return
     */
    List<YoutuiActivityDto> getShareList();

    /**
     * 根据id获取活动
     * @param id
     * @return
     */
    YoutuiActivityDto getById(Long id);

    /**
     * 根据ids获取活动
     * @return
     */
    List<YoutuiActivityDto> getByIds(List<Long> ids);

    /**
     * 查询活动皮肤的数据信息
     * @param activityId 活动id
     */
    YoutuiSkinDataDto selectActivitySkinByActivityId(Long activityId);



    /**
     * 查询活动的奖项
     * @param activityId 活动id
     * @param includeStock 是否包含库存
     * @return
     */
    List<YoutuiOptionDto> selectActivityOptionByActivityId(Long activityId, Boolean includeStock);

    /**
     * 通过skinType查询活动皮肤模板
     * @param skinType
     * @return
     */
    YoutuiSkinTemplateDto selectSkinTemplateBySkinType(String skinType);
}
