package cn.com.duiba.tuia.activity.center.api.constant;

import cn.com.duiba.tuia.activity.center.api.common.Probability;
import cn.com.duiba.tuia.activity.center.api.util.Prob;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

/**
 * Created by wubo on 2017/8/16.
 */
public enum LayerSkinType {

    ALIPAY_QUOTA(1, "支付宝-定额"),
    ALIPAY_RANDOM(2, "支付宝-随机"),
    THANKS(3, "谢谢参与"),
    COUPON(4, "广告"),
    RECOMMEND(5, "推荐弹层"),
    PHYSICAL(6, "实物弹层"),
    VIRTUAL(7, "虚拟奖品弹层"),
    QB_QUOTA(8, "腾讯QB-定额"),
    QB_RANDOM(9, "腾讯QB-随机"),
    BILL_QUOTA(10, "话费-定额"),
    BILL_RANDOM(11, "话费-随机"),

    CUSTOM_3341(21, "定制弹层1(3341)"),
    CUSTOM_5371(22, "定制弹层2(5371)"),
    CUSTOM_3340(23, "定制弹层3(3340)"),
    CUSTOM_1983(24, "定制弹层4(1983)"),

    COUPON_EDUCATION(41, "行业广告弹层-教育"),
    COUPON_LOAN(42, "行业广告弹层-借贷"),
    COUPON_INSURANCE(43, "行业广告弹层-保险"),
    COUPON_MOBILE_GAMES(44, "行业广告弹层-手游"),
    COUPON_LOTTERY_TICKET(45, "行业广告弹层-彩票"),

    THANKS_STYLE1(31, "谢谢参与1"),
    THANKS_STYLE2(32, "谢谢参与2"),
    ;

    private Integer group;
    private Integer type;
    private String desc;

    LayerSkinType(Integer type, String desc) {
        this.group = SkinGroup.LAYER.getGroup();
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getGroup() {
        return group;
    }


    private final static Prob<LayerSkinType> thankLayers = new Prob<>();
    static{
        //thankLayers.put(LayerSkinType.THANKS, new Probability(40));
        thankLayers.put(LayerSkinType.THANKS_STYLE1, new Probability(50));
        thankLayers.put(LayerSkinType.THANKS_STYLE2, new Probability(50));
    }

    /**
     * 概率获取定制弹层type
     * @return
     */
    public static Integer getRandomThanks() {
        return thankLayers.getPercentRandom().getType();
    }



    private static List<Integer> constantTypes = new ArrayList<>();
    static {
        constantTypes.add(ALIPAY_QUOTA.getType());
        constantTypes.add(ALIPAY_RANDOM.getType());
        constantTypes.add(PHYSICAL.getType());
        constantTypes.add(VIRTUAL.getType());
        constantTypes.add(QB_QUOTA.getType());
        constantTypes.add(QB_RANDOM.getType());
        constantTypes.add(BILL_QUOTA.getType());
        constantTypes.add(BILL_RANDOM.getType());
        constantTypes.add(THANKS.getType());
        constantTypes.add(RECOMMEND.getType());
    }

    private static Map<Long, Integer> customSkin = new HashMap<>();//定制弹层
    static {
        //弹层1,id=67
        customSkin.put(5534L, CUSTOM_3341.getType());
        customSkin.put(5908L, CUSTOM_3341.getType());
        customSkin.put(5537L, CUSTOM_3341.getType());
        customSkin.put(5226L, CUSTOM_3341.getType());
        customSkin.put(5813L, CUSTOM_3341.getType());
        customSkin.put(5903L, CUSTOM_3341.getType());
        customSkin.put(5592L, CUSTOM_3341.getType());
        customSkin.put(5650L, CUSTOM_3341.getType());

        //弹层2,id=68
        customSkin.put(5709L, CUSTOM_5371.getType());
        customSkin.put(5887L, CUSTOM_5371.getType());
        customSkin.put(4118L, CUSTOM_5371.getType());
        customSkin.put(5896L, CUSTOM_5371.getType());
        customSkin.put(5912L, CUSTOM_5371.getType());
        customSkin.put(5270L, CUSTOM_5371.getType());
        customSkin.put(5711L, CUSTOM_5371.getType());

        //弹层3,id=69
        customSkin.put(5868L, CUSTOM_3340.getType());
        customSkin.put(5278L, CUSTOM_3340.getType());
        customSkin.put(5881L, CUSTOM_3340.getType());
        customSkin.put(5199L, CUSTOM_3340.getType());
        customSkin.put(4573L, CUSTOM_3340.getType());
        customSkin.put(4881L, CUSTOM_3340.getType());
        customSkin.put(5906L, CUSTOM_3340.getType());
        customSkin.put(5910L, CUSTOM_3340.getType());

        //弹层4,id=70
        customSkin.put(675L, CUSTOM_1983.getType());
        customSkin.put(5040L, CUSTOM_1983.getType());
        customSkin.put(1092L, CUSTOM_1983.getType());
        customSkin.put(5918L, CUSTOM_1983.getType());
        customSkin.put(5913L, CUSTOM_1983.getType());
        customSkin.put(5885L, CUSTOM_1983.getType());
        customSkin.put(5882L, CUSTOM_1983.getType());
        customSkin.put(5201L, CUSTOM_1983.getType());
        customSkin.put(5227L, CUSTOM_1983.getType());
        customSkin.put(5283L, CUSTOM_1983.getType());

    }

    public static Integer getCustomSkinType(Long activityId) {
        if (activityId == null) {
            return null;
        }
        return customSkin.get(activityId);
    }


    /**
     * 中奖弹层 唯一的皮肤类型
     * @return
     */
    public static List<Integer> getConstantSkinTypes() {
        return constantTypes;
    }

    private static Map<Integer, LayerSkinType> map =new HashMap<>();
    static {
        for (LayerSkinType layer : LayerSkinType.values()) {
            map.put(layer.getType(), layer);
        }
    }

    public static LayerSkinType getByType(int type) {
        return map.get(type);
    }

    public static String getDescByType(int type) {
        LayerSkinType layer = getByType(type);
        if (layer != null) {
            return layer.getDesc();
        } else {
            return "未定义";
        }
    }

    public static JSONArray getAll() {
        JSONArray jsons = new JSONArray();
        for (LayerSkinType layer : LayerSkinType.values()) {
            JSONObject json = new JSONObject();
            json.put(FieldNameSpace.TYPE, layer.getType());
            json.put(FieldNameSpace.DESC, layer.getDesc());
            jsons.add(json);
        }
        return jsons;
    }

}
