package cn.com.duiba.tuia.activity.center.api.dto;

import com.alibaba.fastjson.JSON;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 三级押注游戏配置（猫奴）
 */
public class Bet2ConfigDto extends RuleConfigDto implements Serializable {

    public static void main(String[] args) {
        Bet2ConfigDto bet2ConfigDto = new Bet2ConfigDto();
        BetAmount betAmount = new BetAmount();
        betAmount.setFirst(100);
        betAmount.setSecond(1000);
        betAmount.setThird(10000);

        ReturnTimes returnTimes = new ReturnTimes();
        returnTimes.setLev1(1.0);
        returnTimes.setLev2(2.0);
        returnTimes.setLev3(3.0);

        Bet2Materials bet2Materials = new Bet2Materials();
        BettingDto.BetMaterial betMaterial = new BettingDto.BetMaterial();
        betMaterial.setHeight(100);
        betMaterial.setWidth(100);
        betMaterial.setMaterialName("素材");
        betMaterial.setMaterialUrl("素材url");
        bet2Materials.setAdvertBoxImgUrl(betMaterial);

        bet2ConfigDto.setBetAmount(betAmount);
        bet2ConfigDto.setReturnTimes(returnTimes);
        bet2ConfigDto.setAlmsAmount(1000L);
        bet2ConfigDto.setAlmsTimes(3);
        bet2ConfigDto.setBet2Materials(bet2Materials);

        RobotConfig robotConfig = new RobotConfig();
        robotConfig.setBetAmountLeft(0);
        robotConfig.setBetAmountRight(1);
        robotConfig.setBetIntervalLeft(0L);
        robotConfig.setBetIntervalRight(1L);
        robotConfig.setGameSecondsLeft(0L);
        robotConfig.setGameSecondsRight(1L);
        RobotConfig.BetLevRatio betLevRatio = new RobotConfig.BetLevRatio();
        betLevRatio.setLev1Ratio(20);
        betLevRatio.setLev2Ratio(45);
        betLevRatio.setLev3Ratio(35);
        robotConfig.setBetLevRatio(betLevRatio);
        robotConfig.setTitle("机器人批次配置");

        ArrayList<RobotConfig> robotConfigs = new ArrayList<>();
        robotConfigs.add(robotConfig);
        bet2ConfigDto.setRobotConfigs(robotConfigs);

        System.err.println(bet2ConfigDto.toJsonString());
    }

    //押注金额配置
    private BetAmount betAmount;

    //返奖倍数
    private ReturnTimes returnTimes;

    //机器人批次配置
    private List<RobotConfig> robotConfigs;

    //救济金额度（单次）
    private Long almsAmount;

    //救济金领取次数（每日）
    private Integer almsTimes;

    //广告宝箱素材对象
    private Bet2Materials bet2Materials;

    /**
     * 是否启用福袋 0关闭 1开启
     */
    private int luckyBag;

    public Bet2Materials getBet2Materials() {
        return bet2Materials;
    }

    public void setBet2Materials(Bet2Materials bet2Materials) {
        this.bet2Materials = bet2Materials;
    }

    public Long getAlmsAmount() {
        return almsAmount;
    }

    public void setAlmsAmount(Long almsAmount) {
        this.almsAmount = almsAmount;
    }

    public Integer getAlmsTimes() {
        return almsTimes;
    }

    public void setAlmsTimes(Integer almsTimes) {
        this.almsTimes = almsTimes;
    }

    public List<RobotConfig> getRobotConfigs() {
        return robotConfigs;
    }

    public void setRobotConfigs(List<RobotConfig> robotConfigs) {
        this.robotConfigs = robotConfigs;
    }

    public BetAmount getBetAmount() {
        return betAmount;
    }

    public void setBetAmount(BetAmount betAmount) {
        this.betAmount = betAmount;
    }

    public ReturnTimes getReturnTimes() {
        return returnTimes;
    }

    public void setReturnTimes(ReturnTimes returnTimes) {
        this.returnTimes = returnTimes;
    }

    public int getLuckyBag() {
        return luckyBag;
    }

    public void setLuckyBag(int luckyBag) {
        this.luckyBag = luckyBag;
    }

    /**
     * 押注金额
     */
    public static class BetAmount implements Serializable {
        //梯度1
        private Integer first;

        //梯度2
        private Integer second;

        //梯度3
        private Integer third;

        public Integer getFirst() {
            return first;
        }

        public void setFirst(Integer first) {
            this.first = first;
        }

        public Integer getSecond() {
            return second;
        }

        public void setSecond(Integer second) {
            this.second = second;
        }

        public Integer getThird() {
            return third;
        }

        public void setThird(Integer third) {
            this.third = third;
        }
    }

    /**
     * 返奖倍数
     */
    public static class ReturnTimes implements Serializable {
        //一级区域
        private Double lev1;

        //二级区域
        private Double lev2;

        //三级区域
        private Double lev3;

        public Double getLev1() {
            return lev1;
        }

        public void setLev1(Double lev1) {
            this.lev1 = lev1;
        }

        public Double getLev2() {
            return lev2;
        }

        public void setLev2(Double lev2) {
            this.lev2 = lev2;
        }

        public Double getLev3() {
            return lev3;
        }

        public void setLev3(Double lev3) {
            this.lev3 = lev3;
        }
    }

    /**
     * 押注区域级别
     */
    private static enum BetLev {

        one(1), two(2), three(3);

        private Integer code;

        BetLev(Integer code) {
            this.code = code;
        }
    }

    /**
     * 押注项构造器
     */
    public static class BetOptionBuilder {
        private static Map<Long, BetOption> BETOPTIONMAP = new HashMap<>();
        private static final String[] TITLES = {"白羊座", "狮子座", "射手座", "金牛座", "处女座", "摩羯座", "天秤座", "水瓶座", "双子座", "巨蟹座", "天蝎座", "双鱼座", "火象星座", "土象星座", "风象星座", "水象星座", "傲娇公猫", "软萌母猫"};


        private BetOptionBuilder() {

        }

        public static Map<Long, BetOption> initBetOption() {
            if (BETOPTIONMAP.isEmpty()) {
                // List<BetOption> children2 = Lists.newArrayList();
                // List<BetOption> children = Lists.newArrayList();
                for (int i = 0; i < 12; i++) {
                    BetOption bp3 = new BetOption((long) (i + 1), 3, i / 3 + 13, TITLES[i], null);
                    //children2.add(JSON.parseObject(JSON.toJSONString(bp3), BetOption.class));
                    BETOPTIONMAP.put(bp3.getId(), bp3);
                    int lev2 = (i + 1) % 3;
                    if (lev2 == 0) {
                        BetOption bp2 = new BetOption((long) (13 + i / 3), 2, 17 + i / 6, TITLES[13 + i / 3 - 1], null);
                        // children2.clear();
                        //children.add(JSON.parseObject(JSON.toJSONString(bp2), BetOption.class));
                        BETOPTIONMAP.put(bp2.getId(), bp2);
                    }
                    int lev3 = (i + 1) % 6;
                    if (lev3 == 0) {
                        BetOption bp = new BetOption((long) (17 + i / 6), 1, null, TITLES[17 + i / 6 - 1], null);
                        BETOPTIONMAP.put(bp.getId(), bp);
                        // children.clear();
                    }
                }
            }
            return BETOPTIONMAP;
        }

        public static void main(String[] args) {
            System.err.println(JSON.toJSONString(initBetOption()));
        }

    }

    /**
     * 押注项
     */
    public static class BetOption {

        //押注项Id
        private Long id;

        //押注项级别
        private Integer betLev;

        //父押注项
        private Integer pid;

        //押注项标题
        private String title;

        //子押注项
        private List<BetOption> children;

        public BetOption() {
        }

        public BetOption(Long id, Integer betLev, Integer pid, String title, List<BetOption> children) {
            this.id = id;
            this.betLev = betLev;
            this.pid = pid;
            this.title = title;
            if (null != children) {
                this.children = new ArrayList<>(children);
            }
        }

        public List<BetOption> getChildren() {
            return children;
        }

        public void setChildren(List<BetOption> children) {
            this.children = children;
        }

        public Integer getBetLev() {
            return betLev;
        }

        public void setBetLev(Integer betLev) {
            this.betLev = betLev;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Integer getPid() {
            return pid;
        }

        public void setPid(Integer pid) {
            this.pid = pid;
        }
    }

    public static class RobotConfig implements Serializable {

        //机器人配置标题
        private String title;

        //机器人游戏时长下限
        private Long gameSecondsLeft;

        //机器人游戏时长上限
        private Long gameSecondsRight;

        //机器人单局投注金额下限
        private Integer betAmountLeft;

        //机器人单局投注金额上限
        private Integer betAmountRight;

        //机器人投注间隔下限
        private Long betIntervalLeft;

        //机器人投注间隔上限
        private Long betIntervalRight;

        //机器人三级区域押注比例
        private BetLevRatio betLevRatio;

        public BetLevRatio getBetLevRatio() {
            return betLevRatio;
        }

        public void setBetLevRatio(BetLevRatio betLevRatio) {
            this.betLevRatio = betLevRatio;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Long getGameSecondsLeft() {
            return gameSecondsLeft;
        }

        public void setGameSecondsLeft(Long gameSecondsLeft) {
            this.gameSecondsLeft = gameSecondsLeft;
        }

        public Long getGameSecondsRight() {
            return gameSecondsRight;
        }

        public void setGameSecondsRight(Long gameSecondsRight) {
            this.gameSecondsRight = gameSecondsRight;
        }

        public Integer getBetAmountLeft() {
            return betAmountLeft;
        }

        public void setBetAmountLeft(Integer betAmountLeft) {
            this.betAmountLeft = betAmountLeft;
        }

        public Integer getBetAmountRight() {
            return betAmountRight;
        }

        public void setBetAmountRight(Integer betAmountRight) {
            this.betAmountRight = betAmountRight;
        }

        public Long getBetIntervalLeft() {
            return betIntervalLeft;
        }

        public void setBetIntervalLeft(Long betIntervalLeft) {
            this.betIntervalLeft = betIntervalLeft;
        }

        public Long getBetIntervalRight() {
            return betIntervalRight;
        }

        public void setBetIntervalRight(Long betIntervalRight) {
            this.betIntervalRight = betIntervalRight;
        }

        /**
         * 三级区域押注比例
         */
        public static class BetLevRatio {

            //一级区域比例
            private Integer lev1Ratio;
            //二级区域比例
            private Integer lev2Ratio;
            //三级区域比例
            private Integer lev3Ratio;

            public Integer getLev1Ratio() {
                return lev1Ratio;
            }

            public void setLev1Ratio(Integer lev1Ratio) {
                this.lev1Ratio = lev1Ratio;
            }

            public Integer getLev2Ratio() {
                return lev2Ratio;
            }

            public void setLev2Ratio(Integer lev2Ratio) {
                this.lev2Ratio = lev2Ratio;
            }

            public Integer getLev3Ratio() {
                return lev3Ratio;
            }

            public void setLev3Ratio(Integer lev3Ratio) {
                this.lev3Ratio = lev3Ratio;
            }
        }
    }

    /**
     * 押注2素材配置
     */
    public static class Bet2Materials {

        //广告宝箱素材图片
        private BettingDto.BetMaterial advertBoxImgUrl;

        public BettingDto.BetMaterial getAdvertBoxImgUrl() {
            return advertBoxImgUrl;
        }

        public void setAdvertBoxImgUrl(BettingDto.BetMaterial advertBoxImgUrl) {
            this.advertBoxImgUrl = advertBoxImgUrl;
        }
    }
}


