package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.Objects;

/**
 * ClassName: ActivityOptionType <br/>
 * Function: 奖项类型枚举. <br/>
 * date: 2017年1月13日 下午2:53:09 <br/>
 *
 * @author wubo
 * @version 1.0
 * @since JDK 1.7
 */
public enum OrderAlipayType {

    VIRTUAL_CURRENCY("virtualCurrency", 30, "虚拟兑换币"),
    RED_PACKET_CURRENCY("redPacketCurrency", 41, "红包提现");


    /**
     * code:奖项类型.
     */
    private String code;

    /**
     * 订单表AlipayType
     */
    private Integer status;

    /**
     * desc:奖项类型描述.
     */
    private String desc;

    OrderAlipayType(String code, Integer status, String desc) {
        this.code = code;
        this.status = status;
        this.desc = desc;
    }

    public static OrderAlipayType getTypeByStatus(Integer status){
        if(status==null){
            return null;
        }
        OrderAlipayType[] values = OrderAlipayType.values();
        for (OrderAlipayType type:values) {
            if(Objects.equals(type.getStatus(),status)){
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

}
