package cn.com.duiba.tuia.activity.center.api.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

/**
 * ClassName: ActivityOrderDto <br/>
 * Function: 活动订单Dto. <br/>
 * date: 2017年2月24日 下午2:54:16 <br/>
 *
 * @author wubo
 * @since JDK 1.7
 */
public class ActivityOrderDto extends BaseDto {

    /**
     * 优惠券扩展字段名
     */
    public class CouponInfo {

        private CouponInfo() {}
        /**
         * The Constant TITLE.
         */
        public static final String TITLE = "title";

        /**
         * The Constant THUMBNAIL_PNG.
         */
        public static final String THUMBNAIL_PNG = "thumbnailPng";

        /**
         * The Constant END_VALID.
         */
        public static final String END_VALID = "endValid";

        /**
         * The Constant aadvert fee.
         */
        public static final String ADVERT_FEE = "fee";

        public static final String ACG_ID = "acgId";

        public static final String MATERIAL_BUTTON = "materialButton";

        public static final String PACKAGE_ID = "packageId";
    }

    /**
     * 奖品库奖项扩展字段名
     */
    public class PrizeInfo {

        private PrizeInfo(){}

        /** 奖项标题，不是奖品的 */
        public static final String TITLE = "title";

        /**
         * listImage:奖项列表图片 250*250.
         */
        public static final String LIST_IMAGE = "listImage";

        /**
         * bannerImage:我的奖品banner图 225*140.
         */
        public static final String BANNER_IMAGE = "bannerImage";

        /**
         * detailImage:详情图，奖项说明详情图 640*300.
         */
        public static final String DETAIL_IMAGE = "detailImage";

        /**
         * randomCoin 奖品项为随机金额时,本次所获得的随机金额
         */
        public static final String RANDOM_COIN = "randomCoin";
    }

    private static final long serialVersionUID = -7128691201032866126L;

    private Long id;

    private String orderId;

    private Long appId;

    private Long consumerId;

    private Long activityId;

    private Integer activityType;

    private Long prizeId;

    private Long advertId;

    private Long gid;

    private Integer gtype;

    private String prizeType;

    private Long sourceOrderId;

    private String ip;

    private String couponData;

    private Date gmtCreate;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getGid() {
        return gid;
    }

    public void setGid(Long gid) {
        this.gid = gid;
    }

    public Integer getGtype() {
        return gtype;
    }

    public void setGtype(Integer gtype) {
        this.gtype = gtype;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public Long getSourceOrderId() {
        return sourceOrderId;
    }

    public void setSourceOrderId(Long sourceOrderId) {
        this.sourceOrderId = sourceOrderId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCouponData() {
        return couponData;
    }

    public void setCouponData(String couponData) {
        this.couponData = couponData;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**更据扩展字段的key获取值，没用返回""*/
    public String getCouponData(String key) {
        return StringUtils.isNotBlank(this.couponData) ? JSONObject.parseObject(this.couponData).getString(key) : StringUtils.EMPTY;
    }

    public void setCouponData(Map<String, String> map){
        this.couponData = JSON.toJSONString(map);
    }

}
