package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.PeopleTagDto;

import java.util.List;

/**
 * Created by weny.cai on 2018/5/25.
 */
@AdvancedFeignClient
public interface RemoteUserPreferenceService {

    /**
     * 根据设备ID获取
     * 用户偏好数据
     * @param deviceId
     */
    Boolean getUserPreference(String deviceId);

    /**
     * 根据设备ID获取
     * 用户偏好数据
     * @param deviceId 设备ID
     * @param industry 行业字符
     */
    Boolean getPreferenceByIndustry(String deviceId, String industry);

    /**
     * 根据人群数据标签
     * 筛选出喜好的人群
     * @param deviceId
     * @param dtos
     * @return
     */
    List<PeopleTagDto> getPreferenceByList(String deviceId, List<PeopleTagDto> dtos);

    /**
     * 获取用户的IMEI
     *
     * @param deviceId 设备id
     * @return IMEI
     */
    String getImei(String deviceId);

    /**
     * 判断用户是否命中至少一个兴趣标签
     *
     * @param deviceId 设备id
     * @param tags 标签列表
     * @return 命中至少一个兴趣标签
     */
    Boolean isInterestedIn(String deviceId, List<String> tags);

    /**
     * 是否命中角色扮演游戏标签
     *
     * @param deviceId 设备id
     * @return 是否命中
     */
    Boolean isHitRolePlayGameTag(String deviceId);

    /**
     * 是否男性
     *
     * @param deviceId 设备id
     * @return 是否男性
     */
    Boolean isMan(String deviceId);

    /**
     * 是否是对游戏感兴趣
     *
     * @param deviceId 设备id
     * @return 是否对游戏感兴趣
     */
    Boolean isInterestedInGame(String deviceId);
}
