/**
 * Project Name:activity-center-api<br>
 * File Name:EntranceType.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.constant<br>
 * Date:2017年3月30日下午2:00:30<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.constant;

/**
 * ClassName: EntranceType <br/>
 * Function: 入口类型. <br/>
 * Reason: 概率查询，数据展示等场景需要区分入口类型. <br/>
 * date: 2017年3月30日 下午2:00:30 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public enum EntranceType {
    BROB(1, "浮标", "tuia_buoy_rate_new20171202"),
    BACK(2, "返回", "tuia_return_rate_new20171202"),
    /** 浮标额外存储部分. */
    BROB_EXT(3, "浮标EXT", "tuia_buoy_ext"),
    PRIZERECOMMEDN(4,"推荐弹层福利按钮","tuia_prize_recommend_rate"),
    BACK_AGAIN(5, "二次返回", "tuia_return_rate_new20180523"),
    BROB_CONFIG(6, "浮标配置", "tuia_buoy_config_rate_new20180601"),
    BROB_PULL_DOWN(7, "下拉", "tuia_buoy_pull_rate_new20180625"),
    PEOPLE_TAG(8, "浮标人群包", "tuia_people_tag_rate_new20180704"),
    BACK_CONFIG(9, "返回配置", "tuia_back_config_rate_new20180704"),
    SLOT_BACK_CONFIG(10, "返回拦截定向到广告位", "tuia_slot_back_new20181025");

    /** type:入口type值. */
    private Integer type;

    /** desc:描述. */
    private String  desc;

    /** key:概率配置项对应的key. */
    private String  key;

    EntranceType() {}

    EntranceType(Integer type, String desc, String key) {
        this.type = type;
        this.desc = desc;
        this.key = key;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getKey() {
        return key;
    }

    /**
     * getProbType:(根据type值获取对应的枚举). <br/>
     * 
     * @param type 类型
     * @return ProbType
     */
    public static EntranceType getEntranceType(int type) {
        for (EntranceType temp : EntranceType.values()) {
            if (temp.getType() == type) {
                return temp;
            }
        }
        return null;
    }

}
