package cn.com.duiba.tuia.activity.center.api.dto;

import java.io.Serializable;
import java.util.List;

public class BettingDto extends RuleConfigDto implements Serializable {


    private static final long serialVersionUID = -704935208458908536L;
    /**
     * 押注配置
     */
    private List<BettingConfig> bettingConfigList;

    /**
     * 押注素材
     */
    private List<BetMaterial> betMaterials;

    public List<BettingConfig> getBettingConfigList() {
        return bettingConfigList;
    }

    public void setBettingConfigList(List<BettingConfig> bettingConfigList) {
        this.bettingConfigList = bettingConfigList;
    }

    public List<BetMaterial> getBetMaterials() {
        return betMaterials;
    }

    public void setBetMaterials(List<BetMaterial> betMaterials) {
        this.betMaterials = betMaterials;
    }

    public static class BettingConfig implements Serializable {

        private static final long serialVersionUID = 8891720784610910749L;

        /**
         * 押注项描述
         */
        private String desc;
        /**
         * 押注项ID
         */
        private Integer id;

        /**
         * 押注选项名称
         */
        private String betName;

        /**
         * 返奖倍数
         */
        private Integer rewardMultiples;

        /**
         * 权重
         */
        private Integer weights;

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Integer getId() {
            return id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Integer getRewardMultiples() {
            return rewardMultiples;
        }

        public void setRewardMultiples(Integer rewardMultiples) {
            this.rewardMultiples = rewardMultiples;
        }

        public Integer getWeights() {
            return weights;
        }

        public void setWeights(Integer weights) {
            this.weights = weights;
        }

        public String getBetName() {
            return betName;
        }

        public void setBetName(String betName) {
            this.betName = betName;
        }
    }

    public static class BetMaterial implements Serializable {

        private static final long serialVersionUID = 4541853177817800720L;
        /**
         * 素材名称
         */
        private String materialName;

        /**
         * 素材url
         */
        private String  materialUrl;
        /**
        * 素材宽
        */
        private Integer width;
        /**
         * 素材高
         */
        private Integer height;

        /**
         * 下载图片地址
         */
        private String downloadUrl;

        public String getMaterialName() {
            return materialName;
        }

        public void setMaterialName(String materialName) {
            this.materialName = materialName;
        }

        public String getMaterialUrl() {
            return materialUrl;
        }

        public void setMaterialUrl(String materialUrl) {
            this.materialUrl = materialUrl;
        }

        public static long getSerialVersionUID() {
            return serialVersionUID;
        }

        public Integer getWidth() {
            return width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Integer getHeight() {
            return height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public String getDownloadUrl() {
            return downloadUrl;
        }

        public void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }
    }
}
