/**
 * Project Name:activity-center-api<br>
 * File Name:LandDto.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年3月23日下午7:46:46<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import java.math.BigDecimal;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;

/**
 * ClassName: LandDto <br/>
 * Function: 落地页Dto. <br/>
 * Reason: 落地页基本信息. <br/>
 * date: 2017年3月23日 下午7:46:46 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class LandDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    private Long              id;

    /** title:落地页标题. */
    private String            title;

    /** html:落地页皮肤. */
    private String            html;

    /** channel:渠道类型. */
    private String            channel;
    
    /** 网页名称. */
    private String            name;

    /** 0：代码添加，1：模板添加. */
    private Integer           landType;

    /** 自动下载：0-非，1-是. */
    private Integer           autoDownload;

    /** 自动下载时间. */
    private Integer           autoDownloadTime;

    /** 安卓下载地址. */
    private String            downloadAndriod;

    /** ios下载地址. */
    private String            downloadIos;

    /** sso系统AE用户id. */
    private Long              ssoAeId;

    /** 自动跳转类型：0:链接,1:弹层 */
    private Integer           autoDownloadType;

    /**落地页来源：1：来自广告管理平台，0：来自代理商平台*/
    private Integer           source;
    private String thumbnailUrl;

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    /**
     * autoDownloadType.
     *
     * @return the autoDownloadType
     * @since JDK 1.8
     */
    public Integer getAutoDownloadType() {
        return autoDownloadType;
    }

    /**
     * autoDownloadType.
     *
     * @param autoDownloadType the autoDownloadType to set
     * @since JDK 1.8
     */
    public void setAutoDownloadType(Integer autoDownloadType) {
        this.autoDownloadType = autoDownloadType;
    }

    /**
     * name.
     *
     * @return the name
     * @since JDK 1.8
     */
    public String getName() {
        return name;
    }

    /**
     * name.
     *
     * @param name the name to set
     * @since JDK 1.8
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * landType.
     *
     * @return the landType
     * @since JDK 1.8
     */
    public Integer getLandType() {
        return landType;
    }

    /**
     * landType.
     *
     * @param landType the landType to set
     * @since JDK 1.8
     */
    public void setLandType(Integer landType) {
        this.landType = landType;
    }

    /**
     * autoDownload.
     *
     * @return the autoDownload
     * @since JDK 1.8
     */
    public Integer getAutoDownload() {
        return autoDownload;
    }

    /**
     * autoDownload.
     *
     * @param autoDownload the autoDownload to set
     * @since JDK 1.8
     */
    public void setAutoDownload(Integer autoDownload) {
        this.autoDownload = autoDownload;
    }
    
    /**
     * autoDownloadTime.
     *
     * @return  the autoDownloadTime
     * @since   JDK 1.8
     */
    public Integer getAutoDownloadTime() {
        return autoDownloadTime;
    }

    /**
     * autoDownloadTime.
     *
     * @return the autoDownloadTime
     * @since JDK 1.8
     */
    public Double getAutoDownloadDoubleTime() {
        if (autoDownloadTime == null) {
            return null;
        }
        BigDecimal dividendDouble = new BigDecimal(autoDownloadTime);
        BigDecimal divisorDouble = new BigDecimal(10);
        return dividendDouble.divide(divisorDouble, 1, BigDecimal.ROUND_HALF_UP).doubleValue();
    }
    
    /**
     * autoDownloadTime.
     *
     * @param   autoDownloadTime    the autoDownloadTime to set
     * @since   JDK 1.8
     */
    public void setAutoDownloadTime(Integer autoDownloadTime) {
        this.autoDownloadTime = autoDownloadTime;
    }


    /**
     * autoDownloadTime.
     *
     * @param autoDownloadTime the autoDownloadTime to set
     * @since JDK 1.8
     */
    public void setAutoDownloadDoubleTime(Double autoDownloadTimeDouble) {
        if (autoDownloadTimeDouble == null) {
            this.autoDownloadTime = null;
        }else {
            this.autoDownloadTime = (int) (autoDownloadTimeDouble*10);
        }
    }

    /**
     * downloadAndriod.
     *
     * @return the downloadAndriod
     * @since JDK 1.8
     */
    public String getDownloadAndriod() {
        return downloadAndriod;
    }

    /**
     * downloadAndriod.
     *
     * @param downloadAndriod the downloadAndriod to set
     * @since JDK 1.8
     */
    public void setDownloadAndriod(String downloadAndriod) {
        this.downloadAndriod = downloadAndriod;
    }

    /**
     * downloadIos.
     *
     * @return the downloadIos
     * @since JDK 1.8
     */
    public String getDownloadIos() {
        return downloadIos;
    }

    /**
     * downloadIos.
     *
     * @param downloadIos the downloadIos to set
     * @since JDK 1.8
     */
    public void setDownloadIos(String downloadIos) {
        this.downloadIos = downloadIos;
    }

    /**
     * ssoAeId.
     *
     * @return the ssoAeId
     * @since JDK 1.8
     */
    public Long getSsoAeId() {
        return ssoAeId;
    }

    /**
     * ssoAeId.
     *
     * @param ssoAeId the ssoAeId to set
     * @since JDK 1.8
     */
    public void setSsoAeId(Long ssoAeId) {
        this.ssoAeId = ssoAeId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHtml() {
        return html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }
}
