/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.adx;

import cn.com.duiba.tuia.activity.center.api.bean.AdStyle;
import cn.com.duiba.tuia.activity.center.api.bean.AdType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public enum ZhangYueSpecEnum {
    ZHANG_YUE_001(7, "ZHANGYUE001", 1, "\u6a2a\u5e45", 15, "", "\u4e00\u56fe\u4e00\u6587", "{\"height\":608,\"size\":150,\"width\":1080}"),
    ZHANG_YUE_002(7, "ZHANGYUE002", 2, "\u539f\u751f\u4fe1\u606f\u6d41", 16, "1-2", "\u539f\u751f\u4fe1\u606f\u6d41\u8d34\u7247", "{\"descCount\":18,\"height\":360,\"size\":150,\"titleCount\":13,\"width\":640}");

    private Integer adxType;
    private String name;
    private Integer typeKey;
    private String typeValue;
    private Integer styleStandard;
    private String template;
    private String templateDescription;
    private String demand;

    public static List<AdType> generate() {
        ArrayList adTypeList = Lists.newArrayList();
        for (ZhangYueSpecEnum zhangYueSpecEnum : ZhangYueSpecEnum.values()) {
            adTypeList.add(AdType.builder().styleList(ZhangYueSpecEnum.generateAdStyle(zhangYueSpecEnum.getName())).id(zhangYueSpecEnum.getName()).value(zhangYueSpecEnum.getTypeValue()).build());
        }
        return adTypeList;
    }

    public static List<AdStyle> generateAdStyle(String id) {
        ArrayList adStyleList = Lists.newArrayList();
        for (ZhangYueSpecEnum zhangYueSpecEnum : ZhangYueSpecEnum.values()) {
            if (!id.equals(zhangYueSpecEnum.getName())) continue;
            adStyleList.add(AdStyle.builder().styleStandard(zhangYueSpecEnum.getStyleStandard()).description(zhangYueSpecEnum.getTemplateDescription()).build());
        }
        return adStyleList;
    }

    public static String getTemplateIdByStyleStandard(Integer styleStandard) {
        for (ZhangYueSpecEnum zhangYueSpecEnum : ZhangYueSpecEnum.values()) {
            if (!zhangYueSpecEnum.getStyleStandard().equals(styleStandard)) continue;
            return zhangYueSpecEnum.getTemplate();
        }
        return "";
    }

    public static String getDemand(Integer adxType, Integer styleStandard) {
        for (ZhangYueSpecEnum zhangYueSpecEnum : ZhangYueSpecEnum.values()) {
            if (!adxType.equals(zhangYueSpecEnum.getAdxType()) || !styleStandard.equals(zhangYueSpecEnum.getStyleStandard())) continue;
            return zhangYueSpecEnum.getDemand();
        }
        return "";
    }

    public Integer getAdxType() {
        return this.adxType;
    }

    public String getName() {
        return this.name;
    }

    public Integer getTypeKey() {
        return this.typeKey;
    }

    public String getTypeValue() {
        return this.typeValue;
    }

    public Integer getStyleStandard() {
        return this.styleStandard;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public String getDemand() {
        return this.demand;
    }

    private ZhangYueSpecEnum(Integer adxType, String name, Integer typeKey, String typeValue, Integer styleStandard, String template, String templateDescription, String demand) {
        this.adxType = adxType;
        this.name = name;
        this.typeKey = typeKey;
        this.typeValue = typeValue;
        this.styleStandard = styleStandard;
        this.template = template;
        this.templateDescription = templateDescription;
        this.demand = demand;
    }
}

