package cn.com.duiba.tuia.activity.center.api.constant;

public enum ConfigKey {

    DEFAULT_DIRECT_PAGE("default_direct_page","默认直投页id"),
    MENGMA_QPS_LIMIT_TIMES("mengma_qps_limit_times","猛犸直投页限流"),
    BROB("tuia_buoy_rate_new20171202","推啊活动浮标配置跳转去向比率新"),
    BACK_AGAIN("tuia_return_rate_new20180523","推啊二次返回拦截配置跳转去向比率新"),
    BROB_CONFIG("tuia_buoy_config_rate_new20180601","浮标配置"),
    BROB_PULL_DOWN("tuia_buoy_pull_rate_new20180625","下拉"),
    PEOPLE_TAG("tuia_people_tag_rate_new20180704","浮标人群包"),
    BACK_CONFIG("tuia_back_config_rate_new20180704","返回配置"),
    SLOT_BACK_CONFIG("tuia_slot_back_new20181025", "返回拦截定向到广告位"),

    BACK("tuia_return_rate_new20171202","推啊返回拦截配置跳转去向比率新"),
    IP_WHITE_LIST("ip_white_list","ip白名单"),
    PRIZERECOMMEDN("tuia_prize_recommend_rate","推啊推荐弹层福利按钮转去比率"),
    TEST("tuia_game_login_bg_url","tuia游戏登陆背景图"),

    LAYER_AD_TEXT_VISIBLE("layer_ad_text_visible", "弹层广告字样是否显示"),
    PLANT_CASH_STOCK("tuia_activity_plant_cash_stock_appId", "[种红包]提现库存"),
    PLANT_PRIZE_CONFIG("tuia_activity_plant_prize_config_appId", "[种红包]奖励配置"),

    PLANT_V2_CASH_STOCK("tuia_activity_plant_v2_cash_stock_appId", "[种红包V2]提现库存"),
    PLANT_V2_PRIZE_CONFIG("tuia_activity_plant_v2_prize_config_appId", "[种红包V2]奖励配置"),
    PLANT_V2_PRIZE_CONFIG_DEFAULT("tuia_activity_plant_v2_prize_config_default", "[种红包V2]默认奖励配置"),
    PLANT_V2_MISSION_CONFIG("tuia_activity_plant_v2_mission_config_appId", "[种红包V2]奖励配置"),
    PLANT_V2_MISSION_CONFIG_DEFAULT("tuia_activity_plant_v2_mission_config_default", "[种红包V2]默认任务配置"),

    ENCOURAGE_TEST_ADVERT_IDS("tuia_encourage_test_advert_ids", "激励活动用于分流测试的广告ID列表"),

    COMMERCIAL_PLANT_CONFIG_DEFAULT("tuia_activity_commercial_plant_config_default", "[商业化活动]种红包默认配置"),



    DIG_V1_NODE_PRIZE_CONFIG("tuia_activity_dig_v1_node_prize_config_appId", "[挖矿V1]节点奖励配置"),
    DIG_V1_NODE_PRIZE_CONFIG_DEFAULT("tuia_activity_dig_v1_node_prize_config_default", "[挖矿V1]节点默认奖励配置"),
    DIG_V1_STEPS_CONFIG_DEFAULT("tuia_activity_dig_v1_steps_config_default", "[挖矿V1]体力恢复配置"),
    DIG_V1_LAYER_CONFIG_DEFAULT("tuia_activity_dig_v1_layer_config_default", "[挖矿V1]节点默认奖励配置"),
    ;

    private String key;
    private String desc;

    ConfigKey(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getProbType:(根据type值获取对应的枚举). <br/>
     *
     * @param key 类型
     */
    public static ConfigKey getConfigKey(String key) {
        for (ConfigKey temp : ConfigKey.values()) {
            if (temp.getKey().equals(key)) {
                return temp;
            }
        }
        return null;
    }
}
