package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * adx平台类型
 *
 * @author weny.cai
 * @date 2019/1/3 15:46
 **/
public enum AdxTypeEnum {

    LIEBAO(1, "猎豹",false,true),
    SOUGOU(2, "搜狗",false,true),
    MOJI(3, "墨迹天气",false,true),
    BAOFENG(4, "暴风影音",false, false),
    BAIDU(5, "百度视频",true,false),
    XIAOMI(6, "小米",false,false),
    ZHANG_YUE(7,"掌阅",true,false);

    private Integer type;

    private String name;

    private Boolean needAudit;

    private Boolean usePosTypeOrNot;

    AdxTypeEnum(Integer type, String name, Boolean needAudit, Boolean usePosTypeOrNot) {
        this.type = type;
        this.name = name;
        this.needAudit = needAudit;
        this.usePosTypeOrNot = usePosTypeOrNot;
    }

    public Boolean getUsePosTypeOrNot() {
        return usePosTypeOrNot;
    }

    public void setUsePosTypeOrNot(Boolean usePosTypeOrNot) {
        this.usePosTypeOrNot = usePosTypeOrNot;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public Boolean getNeedAudit() {
        return needAudit;
    }

    public boolean sameAdxType(Integer type){
        return !Objects.isNull(type) && Objects.equals(this.type,type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type)
                ? null
                : Stream.of(AdxTypeEnum.values())
                        .filter(item -> Objects.equals(item.getType(), type))
                        .findFirst().orElse(null);
    }

    public static Boolean needAudit(Integer adxType){
        for(AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()){
            if(adxType.equals(adxTypeEnum.getType())){
                return adxTypeEnum.getNeedAudit();
            }
        }
        return false;
    }
}
