package cn.com.duiba.tuia.activity.center.api.constant.commercial.mission;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * [商业化活动]任务奖励枚举
 *
 * @author zhangbaiqiang
 * @date 2019/03/07
 */
public enum MissionPrizeType {

    CASH(1, "CASH", "现金", 0, MissionCycleType.types()),
    LAND_UNLOCK(2, "LAND_UNLOCK", "解锁土地", 1, Collections.singletonList(0)),
    CORN_UNLOCK(3, "CORN_UNLOCK", "解锁玉米", 1, Collections.singletonList(0)),
    PUMPKIN_UNLOCK(4, "PUMPKIN_UNLOCK", "解锁南瓜", 1, Collections.singletonList(0)),
    PITAYA_UNLOCK(5, "PITAYA_UNLOCK", "解锁火龙果", 1, Collections.singletonList(0)),
    BLOCK(6, "BLOCK", "虚拟奖品", 0, MissionCycleType.types()),
    ENCOURAGE(7, "ENCOURAGE", "增值广告", 0, MissionCycleType.types()),
    VIDEO(8, "VIDEO", "视频激励广告", -1, Collections.emptyList()),
    FIRST_PRIZE(9, "FIRST_PRIZE", "新手红包", -1, Collections.emptyList()),
    CASH_LANDING_SHOW(10, "CASH_LANDING_SHOW", "落地页现金奖励", -1, Collections.emptyList()),
    CASH_LANDING_DOWNLOAD(11, "CASH_LANDING_DOWNLOAD", "落地页现金奖励", -1, Collections.emptyList()),
    HEAVENLY_TREASURE_CHEST(12, "HEAVENLY_TREASURE_CHEST", "天降宝箱", -1, Collections.emptyList()),
    VAT_RED_RAIN(13, "VAT_RED_RAIN", "红包雨", -1, Collections.emptyList()),
    VAT_TREASURE_CHEST(14, "VAT_TREASURE_CHEST", "增值任务宝箱", -1, Collections.emptyList()),
    KETTLE_UNLOCK(15, "KETTLE_UNLOCK", "解锁水壶", -1, Collections.emptyList()),
    MANURE_UNLOCK(16, "MANURE_UNLOCK", "解锁肥料", -1, Collections.emptyList()),
    KETTLE(17, "KETTLE", "增加水壶次数", -1, Collections.emptyList()),
    TREE_EXP(18, "TREE_EXP", "增加成长值", -1, Collections.emptyList()),
    MANURE(19, "MANURE", "增加肥料次数", -1, Collections.emptyList()),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 键名
     */
    private String key;

    /**
     * 描述
     */
    private String desc;

    /**
     * 活动类型（0.通用; 1.种红包; 2.挖矿; 3.种树）
     */
    private Integer bizActivityType;

    /**
     * 适用的任务循环类型
     */
    private List<Integer> missionCycleTypes;

    MissionPrizeType(Integer type, String key, String desc, Integer bizActivityType, List<Integer> missionCycleTypes) {
        this.type = type;
        this.key = key;
        this.desc = desc;
        this.bizActivityType = bizActivityType;
        this.missionCycleTypes = missionCycleTypes;
    }

    public Integer getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getBizActivityType() {
        return bizActivityType;
    }

    public List<Integer> getMissionCycleTypes() {
        return missionCycleTypes;
    }

    /**
     * 获取奖励的枚举
     *
     * @param key 奖励类型键名
     * @return 枚举
     */
    public static MissionPrizeType getByKey(String key) {
        for (MissionPrizeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 获取任务的类型
     *
     * @param key 任务奖励键名
     * @return 任务奖励类型
     */
    public static Integer getTypeByKey(String key) {
        for (MissionPrizeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum.getType();
            }
        }
        return null;
    }

    /**
     * 获取任务的类型
     *
     * @param type 任务奖励类型
     * @return 任务奖励键名
     */
    public static String getKeyByType(Integer type) {
        for (MissionPrizeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getKey();
            }
        }
        return null;
    }

    public static boolean isTypeExist(Integer type) {
        for (MissionPrizeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return true;
            }
        }
        return false;
    }
}
