package cn.com.duiba.tuia.activity.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.constant.SkinGroup;
import cn.com.duiba.tuia.activity.center.api.dto.ButtonDto;
import cn.com.duiba.tuia.activity.center.api.dto.LayerSkinDto;
import cn.com.duiba.tuia.activity.center.api.dto.SkinTemplateDataDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.Map;

/**
 * Created by wubo on 2017/8/16.
 * 皮肤相关服务
 */
@AdvancedFeignClient
public interface RemoteSkinService {

    /**
     * 分页查询弹层皮肤
     * @param type 类型 选填
     * @param id id 选填
     * @param name 名称 选填
     * @param offset offset 默认 0
     * @param max max 默认20
     * @return PageDto
     */
    DubboResult<PageDto<LayerSkinDto>> selectLayerSkinPage(Integer type, Long id, String name, Integer offset, Integer max);

    /**
     * 查询弹层皮肤
     * @param id
     * @return
     */
    DubboResult<LayerSkinDto> selectLayerSkin(Long id);

    /**
     * 保存弹层皮肤
     */
    DubboResult<Long> saveLayerSkin(LayerSkinDto dto);

    /**
     * 查询所有类型弹层皮肤
     *
     * 支付宝随机（1个），支付宝定额（1个），谢谢参与（1个），广告弹层（需指定弹层id）
     * @param couponSkinId 广告弹层id
     * @return list
     */
    DubboResult<List<LayerSkinDto>> selectAllLayerSkin(Long couponSkinId);

    /**
     * 查询所有非广告弹层
     * 支付宝随机（1个），支付宝定额（1个），谢谢参与（1个)
     * @return list
     */
    DubboResult<List<LayerSkinDto>> selectConstantLayerSkin();

    /***
         * @Description: selectAllSkinTypes 获取目前所有的活动皮肤名称
         * 保存形式：<skin_type, shin_name>
         * @Param: [dto]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Map>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/9/25
         */
    DubboResult<Map<String, String>> selectAllSkinTypes();

    /**
     * 逻辑删除弹层
     *
     * @return
     */
    DubboResult<Boolean> deleteLayerType(Long id);

    /**
     * 根据id获取按钮样式
     *
     * @param id
     * @return
     */
    DubboResult<ButtonDto> getButtonById(Long id);

    /**
     * 获取所有按钮样式
     *
     * @return
     */
    DubboResult<List<ButtonDto>> getAllButton();

    /**
     * 新增按钮样式
     *
     * @param buttonDto
     * @return
     */
    DubboResult<Boolean> addButton(ButtonDto buttonDto);

    /**
     * 更新按钮样式
     *
     * @param buttonDto
     * @return
     */
    DubboResult<Boolean> updateButton(ButtonDto buttonDto);

    /**
     * 根据类型 查询弹层皮肤
     * @param type 类型
     * @return
     */
    List<LayerSkinDto> selectLayerSkinByType(Integer type);

    /**
     * 查询弹层广告字样是否显示
     *
     * @return 是否显示
     */
    Boolean isLayerAdTextVisible();

    /**
     * 更新弹层广告字样是否显示
     *
     * @param isVisible 是否显示
     * @return 是否更新成功
     */
    Boolean updateLayerAdTextVisible(Boolean isVisible);

    /**
     * selectBySkinTypes:(根据皮肤类型 批量查询). <br/>
     *
     * @param skinTypes 皮肤类型
     * @return map
     */
    Map<String, SkinTemplateDataDto> selectBySkinTypes(List<String> skinTypes);

    /**
     * 根据id查询激励弹层内容
     */
    LayerSkinDto getEncoragelayerById(Long id);

    /**
     * 查询所有激励弹层id
     */
    List<LayerSkinDto> getAllEncoragelayers();
}
