/**
 * Copyright (c) 2019, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.Objects;

/**
 * 描述: 推啊活动类型枚举
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2019/3/13 22:50
 */
public enum TuiaActivityTypeEnum {

    //0:其他类型,1:刮刮卡,2:大转盘,3:娃娃机,4:割绳子,5:彩球机,6:砸彩蛋,
    //7:摇奖机,8:翻牌子,9:踹一踹,10:大海捞金,11:扭蛋机,12:扯红包,13:拆快递,
    //14:套娃娃,15:摇骰子,16:跳房子,17:摇签,18:射箭,19:挖金矿,20:套兔子,
    //21:卡包,22:卡牌,23:吹气球,24:套牛,25:开宝箱,26:打老板,27:剁手机,
    //28:自定义活动,29:直投广告,30:原生化活动

    OTHER(0, "其他类型"),
    SCRATCH_CARD(1, "刮刮卡"),
    TURN_CIRCLE(2, "大转盘"),
    DOLLMAC(3, "娃娃机"),
    CUT_ROPE(4, "割绳子"),
    COLOR_BALL(5, "彩球机"),
    SMASHG(6, "砸彩蛋"),
    TIGER(7, "摇奖机"),
    TURN_CARD(8, "翻牌子"),
    KICK_TREE(9, "踹一踹"),
    FISHING_GOLD(10, "大海捞金"),
    NIU_DAN(11, "扭蛋机"),
    RED_PACKET(12, "扯红包"),
    EXPRESS(13, "拆快递"),
    SET_DOLL(14, "套娃娃"),
    ROLLDICE(15, "摇骰子"),
    HOPSCOTCH(16, "跳房子"),
    DRAW_LOT(17, "摇签"),
    SHOT_ARROW(18, "射箭"),
    DIG_GOLD(19, "挖金矿"),
    CATCH_RABBIT(20, "套兔子"),
    WALLET(21, "卡包"),
    PLAY_CARD(22, "卡牌"),
    BLOW_BALLOON(23, "吹气球"),
    CATCH_OX(24, "套牛"),
    TREASURE(25, "开宝箱"),
    BEAT_BOSS(26, "打老板"),
    CHOPHAND(27, "剁手机"),
    CUSTOMIZE(28, "自定义活动"),
    ACTIVITY_DIRECT(29, "直投广告"),
    SHORT_LINK(30, "原生化活动");

    private Integer type;
    private String desc;

    TuiaActivityTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 是否自定义活动
     *
     * @param activityType
     * @return
     */
    public static Boolean isCustomize(Integer activityType) {
        if (activityType == null) {
            return Boolean.FALSE;
        }
        return Objects.equals(activityType, CUSTOMIZE.getType());
    }

    /**
     * 是否原生化活动
     *
     * @param activityType
     * @return
     */
    public static Boolean isShortLink(Integer activityType) {
        if (activityType == null) {
            return Boolean.FALSE;
        }
        return Objects.equals(activityType, SHORT_LINK.getType());
    }

}
