package cn.com.duiba.tuia.activity.center.api.dto;

import java.util.Collection;
import java.util.Date;

import cn.com.duiba.tuia.activity.center.api.constant.FieldNameSpace;
import cn.com.duiba.tuia.activity.center.api.dto.risk.AuditDto;
import org.apache.commons.lang3.StringUtils;

/**
 * ClassName: TuiaActivityDto <br/>
 * Function: 活动Dto. <br/>
 * date: 2017年2月24日 下午2:56:05 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.8
 */
public class TuiaActivityDto extends AuditDto {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1019469911189459013L;

    private Long              id;
    /** title:活动标题. */
    private String            title;
    /** activityType:活动type. */
    private Integer           activityType;
    /** skinName:皮肤名称. */
    private String            skinName;
    /** activityTypeName:活动类型名称. */
    private String            activityTypeName;
    /** subType:皮肤type. */
    private String            subType;
    /** limitCount:参与次数限制. */
    private Integer           limitCount;
    /** limitScope:限制类型(enum:LimitType). */
    private String            limitScope;
    /** tag:标签. */
    private String            tag;
    /** isDeleted:是否删除. */
    private Boolean           isDeleted;
    /** activityPlanner:活动策划. */
    private String            activityPlanner;
    /** visionPlanner:视觉策划. */
    private String            visionPlanner;
    /** bannerUrl:活动中心banner图. */
    private String            bannerUrl;
    /** recommendUrl:活动中心推荐位. */
    private String            recommendUrl;
    /** listUrl:活动中心列表url. */
    private String            listUrl;
    /** isBuoy:是否开启浮标. */
    private Boolean           isBuoy;
    /** numBuoy:浮标展示频次. */
    private Integer           numBuoy;
    /** isOpen:是否开启,0/1 开启/关闭. */
    private Boolean           isOpen;
    /** autoOffDate:自动关闭时间. */
    private Date              autoOffDate;
    /** buoyId:活动关联的浮标id. */
    private Long              buoyId;
    /** overseas:海外标识，0／1 国内/海外. */
    private Integer           overseas;

    /**
     * 活动置顶
     */
    private Integer top;

    private Date              gmtCreate;

    private Date              gmtModified;

    /**
     * 置顶更改时间
     */
    private Date topGmtModified;

    /**
     * 判断 tag 字段与传过来的集合是否有交集
     * @param coll tag集合
     * @return boolean
     */
    public boolean containTags(Collection<String> coll) {
        if (StringUtils.isBlank(tag) || coll == null || coll.isEmpty()) {
            return false;
        }

        String tags = new StringBuilder(FieldNameSpace.COMMA).append(tag).append(FieldNameSpace.COMMA).toString();

        for (String str : coll) {
            if (tags.contains(FieldNameSpace.COMMA + str + FieldNameSpace.COMMA)) {
                return true;
            }
        }

        return false;
    }

    public Integer getOverseas() {
        return overseas;
    }

    public void setOverseas(Integer overseas) {
        this.overseas = overseas;
    }

    public Long getBuoyId() {
        return buoyId;
    }

    public void setBuoyId(Long buoyId) {
        this.buoyId = buoyId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Boolean getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getActivityPlanner() {
        return activityPlanner;
    }

    public void setActivityPlanner(String activityPlanner) {
        this.activityPlanner = activityPlanner;
    }

    public String getVisionPlanner() {
        return visionPlanner;
    }

    public void setVisionPlanner(String visionPlanner) {
        this.visionPlanner = visionPlanner;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public String getActivityTypeName() {
        return activityTypeName;
    }

    public void setActivityTypeName(String activityTypeName) {
        this.activityTypeName = activityTypeName;
    }

    public String getBannerUrl() {
        return bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    public String getRecommendUrl() {
        return recommendUrl;
    }

    public void setRecommendUrl(String recommendUrl) {
        this.recommendUrl = recommendUrl;
    }

    public String getListUrl() {
        return listUrl;
    }

    public void setListUrl(String listUrl) {
        this.listUrl = listUrl;
    }

    public Boolean getIsBuoy() {
        return isBuoy;
    }

    public void setIsBuoy(Boolean isBuoy) {
        this.isBuoy = isBuoy;
    }

    public Integer getNumBuoy() {
        return numBuoy;
    }

    public void setNumBuoy(Integer numBuoy) {
        this.numBuoy = numBuoy;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Date getAutoOffDate() {
        return autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }

    public Integer getTop() {
        return top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }


    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getTopGmtModified() {
        return topGmtModified;
    }

    public void setTopGmtModified(Date topGmtModified) {
        this.topGmtModified = topGmtModified;
    }
}
