package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.Objects;

/**
 * [种红包V2]任务类型枚举
 *
 * @author zhangbaiqiang
 * @date 2018/12/17
 */
public enum PlantMissionType {

    CASH(1, "CASH", "现金"),
    LAND_UNLOCK(2, "LAND_UNLOCK", "解锁土地"),
    CORN_UNLOCK(3, "CORN_UNLOCK", "解锁玉米"),
    PUMPKIN_UNLOCK(4, "PUMPKIN_UNLOCK", "解锁南瓜"),
    PITAYA_UNLOCK(5, "PITAYA_UNLOCK", "解锁火龙果"),
    BLOCK(6, "BLOCK", "触发区块"),
    ENCOURAGE(7, "ENCOURAGE", "触发激励广告"),
    VIDEO(8, "VIDEO", "视频激励广告"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 键名
     */
    private String key;

    /**
     * 描述
     */
    private String  desc;

    PlantMissionType(Integer type, String key, String desc) {
        this.type = type;
        this.key = key;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取任务的枚举
     *
     * @param key 任务类型键名
     * @return 枚举
     */
    public static PlantMissionType getByKey(String key) {
        for (PlantMissionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum;
            }
        }
        return null;
    }
}
