package cn.com.duiba.tuia.activity.center.api.remoteservice;

/**
 * 用户登录记录服务，目前表里只记录最近一个星期的数据，以前的数据可能会被清除
 */

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteUserLoginHistoryService {
    /**
     * 插入或者更新用户登录时间，保存到七天记录表
     * 每次用户登录的时候会更新用户表时间
     * @param userId 用户ID
     * @return
     */
    Boolean insertOrUpdate(Long userId);
}
