package cn.com.duiba.tuia.activity.center.api.dto.adx;

import cn.com.duiba.tuia.activity.center.api.constant.adx.DefaultFlag;

/**
 * 〈一句话功能简述〉<br>
 * Description: 创意投放比例配置信息
 *
 * @author hillchen
 * @create 2019/2/24 15:06
 */
public class PutRatioDto {
    public static final int FULL_RATIO = 100;

    private Long id;

    private Long resourceId;

    private Long ideaId;

    private Integer putRatio;

    private Integer deleteStatus;

    private Integer defaultFlag;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public Long getIdeaId() {
        return ideaId;
    }

    public void setIdeaId(Long ideaId) {
        this.ideaId = ideaId;
    }

    public Integer getPutRatio() {
        return putRatio;
    }

    public void setPutRatio(Integer putRatio) {
        this.putRatio = putRatio;
    }

    public Integer getDeleteStatus() {
        return deleteStatus;
    }

    public void setDeleteStatus(Integer deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    public Integer getDefaultFlag() {
        return defaultFlag;
    }

    public void setDefaultFlag(Integer defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    public static PutRatioDto buildDefalutRatioDto(Long resourceId,Long ideaId){
        PutRatioDto putRatioDto = buildRatioDto(resourceId,ideaId);
        putRatioDto.setDefaultFlag(DefaultFlag.DEFAULT.getFlag());
        putRatioDto.setPutRatio(FULL_RATIO);
        return putRatioDto;
    }

    public static PutRatioDto buildRatioDto(Long resourceId,Long ideaId,Integer ratio){
        PutRatioDto putRatioDto = buildRatioDto(resourceId,ideaId);
        putRatioDto.setDefaultFlag(DefaultFlag.NONDEDAULT.getFlag());
        putRatioDto.setPutRatio(ratio);
        return putRatioDto;
    }

    private static PutRatioDto buildRatioDto(Long resourceId,Long ideaId){
        PutRatioDto putRatioDto = new PutRatioDto();
        putRatioDto.setResourceId(resourceId);
        putRatioDto.setIdeaId(ideaId);
        return putRatioDto;
    }
}