package cn.com.duiba.tuia.activity.center.api.util.adx;

import cn.com.duiba.tuia.activity.center.api.dto.adx.PutRatioDto;
import cn.com.duiba.tuia.activity.center.api.util.CollectionTool;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx相关工具类
 *
 * @author hillchen
 * @create 2019/2/24 16:16
 */
public class AdxUtils {
    private AdxUtils(){}

    /**
     * 校验投放比例之和是否满100%,默认比例不为负数
     * @param putRatioDtos
     * @return
     */
    public static boolean checkRatioEquesFull(List<PutRatioDto> putRatioDtos){
        if(CollectionTool.isEmpty(putRatioDtos)){
            return false;
        }
        int sumRatio = putRatioDtos.stream()
                .filter(ratio -> ratio != null)
                .mapToInt(ratio -> ratio.getPutRatio() != null ? ratio.getPutRatio() : 0)
                .sum();
        return PutRatioDto.FULL_RATIO == sumRatio;
    }


}