package cn.com.duiba.tuia.activity.center.api.util.adx;

import cn.com.duiba.tuia.activity.center.api.dto.adx.PutRatioDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceLocationDto;
import cn.com.duiba.tuia.activity.center.api.util.CollectionTool;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx相关工具类
 *
 * @author hillchen
 * @create 2019/2/24 16:16
 */
public class AdxUtils {
    private AdxUtils(){}

    /**
     * 校验投放比例之和是否满100%,默认比例不为负数
     * @param putRatioDtos
     * @return
     */
    public static boolean checkRatioEquesFull(List<PutRatioDto> putRatioDtos){
        if(CollectionTool.isEmpty(putRatioDtos)){
            return false;
        }
        int sumRatio = putRatioDtos.stream()
                .filter(ratio -> ratio != null)
                .mapToInt(ratio -> ratio.getPutRatio() != null ? ratio.getPutRatio() : 0)
                .sum();
        return PutRatioDto.FULL_RATIO == sumRatio;
    }

    public static int getPutRatio(PutRatioDto putRatioDto){
        return (!Objects.isNull(putRatioDto) &&
                !Objects.isNull(putRatioDto.getPutRatio()) &&
                putRatioDto.getPutRatio() > 0 ) ? putRatioDto.getPutRatio() : 0;
    }

    /**
     * 转换为标准出价:1000/分，
     * 在数据库中存放的的数据单位为1000/元
     * @param resourceIdeaDto
     * @return
     */
    public static long convertParPrice(ResourceIdeaDto resourceIdeaDto){

        if(!Objects.isNull(resourceIdeaDto) && !Objects.isNull(resourceIdeaDto.getIdeaPrice())){
            return BigDecimal.valueOf(1000).multiply(BigDecimal.valueOf(resourceIdeaDto.getIdeaPrice())).longValue();
        }
        return 0;
    }

    /**
     * 转换为标准出价:1000/分，
     * 在数据库中存放的的数据单位为1000/元
     * @param dbPrice
     * @return
     */
    public static long convertParPrice(Double dbPrice){

        if(!Objects.isNull(dbPrice) ){
            return BigDecimal.valueOf(1000).multiply(BigDecimal.valueOf(dbPrice)).longValue();
        }
        return 0;
    }

    /**
     * 转换为标准出价:1000/分，
     * 在数据库中存放的的数据单位为1000/元
     * @param cpmPrice
     * @return
     */
    public static double convertParPriceToCpm(long cpmPrice){

        return BigDecimal.valueOf(cpmPrice).divide(BigDecimal.valueOf(1000),BigDecimal.ROUND_HALF_UP,2).doubleValue();
    }

    /**
     * 返回付费模式：0:cpc，1:cpm
     * @param resourceLocationDto
     * @return
     */
    public static int convertBillType(ResourceLocationDto resourceLocationDto){
        if(Objects.nonNull(resourceLocationDto) && StringUtils.isNotBlank(resourceLocationDto.getPayType())){
            if(StringUtils.equalsIgnoreCase("CPC",resourceLocationDto.getPayType())){
                return 0;
            }else if(StringUtils.equalsIgnoreCase("CPM",resourceLocationDto.getPayType())){
                return 1;
            }
        }
        return -1;
    }


}